/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.dataset;

import org.apache.avro.Schema;
import org.talend.components.common.SchemaProperties;
import org.talend.components.common.dataset.DatasetProperties;
import org.talend.components.common.dataset.runtime.DatasetRuntime;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.dataset.JDBCDatasetDefinition;
import org.talend.components.jdbc.datastore.JDBCDatastoreProperties;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.ReferenceProperties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;
import org.talend.daikon.runtime.RuntimeInfo;
import org.talend.daikon.runtime.RuntimeUtil;
import org.talend.daikon.sandbox.SandboxedInstance;

public class JDBCDatasetProperties
extends PropertiesImpl
implements DatasetProperties<JDBCDatastoreProperties>,
RuntimeSettingProvider {
    public ReferenceProperties<JDBCDatastoreProperties> datastore = new ReferenceProperties("datastore", "JDBCDatastore");
    public Property<SourceType> sourceType = PropertyFactory.newEnum((String)"sourceType", SourceType.class);
    public Property<String> tableName = PropertyFactory.newString((String)"tableName");
    public Property<String> sql = PropertyFactory.newString((String)"sql");
    public SchemaProperties main = new SchemaProperties("main"){

        public void beforeSchema() {
            JDBCDatasetProperties.this.updateSchema();
        }
    };
    private transient AllSetting setting = new AllSetting();

    public JDBCDatasetProperties(String name) {
        super(name);
    }

    public void afterSourceType() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void updateSchema() {
        JDBCDatasetDefinition definition = new JDBCDatasetDefinition();
        RuntimeInfo runtimeInfo = definition.getRuntimeInfo(this);
        try (SandboxedInstance sandboxedInstance = RuntimeUtil.createRuntimeClass((RuntimeInfo)runtimeInfo, (ClassLoader)this.getClass().getClassLoader());){
            DatasetRuntime runtime = (DatasetRuntime)sandboxedInstance.getInstance();
            runtime.initialize(null, (Properties)this);
            Schema schema = runtime.getSchema();
            this.main.schema.setValue((Object)schema);
        }
    }

    public void setupProperties() {
        this.sourceType.setValue((Object)SourceType.QUERY);
        this.sql.setValue((Object)"select * from mytable");
    }

    public void setupLayout() {
        Form mainForm = CommonUtils.addForm((Properties)this, "Main");
        mainForm.addRow(this.sourceType);
        mainForm.addRow(this.tableName);
        mainForm.addRow(Widget.widget(this.sql).setWidgetType("widget.type.code").setConfigurationValue("language", (Object)"sql"));
        Form citizenUserForm = CommonUtils.addForm((Properties)this, "CitizenUser");
        citizenUserForm.addRow(Widget.widget(this.sql).setWidgetType("widget.type.textArea"));
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        if (form.getWidget(this.tableName) != null) {
            form.getWidget(this.tableName).setVisible(this.sourceType.getValue() == SourceType.TABLE_NAME);
        }
        form.getWidget(this.sql).setVisible(this.sourceType.getValue() == SourceType.QUERY);
    }

    public JDBCDatastoreProperties getDatastoreProperties() {
        return (JDBCDatastoreProperties)this.datastore.getReference();
    }

    public void setDatastoreProperties(JDBCDatastoreProperties datastoreProperties) {
        this.datastore.setReference((Properties)datastoreProperties);
    }

    @Override
    public AllSetting getRuntimeSetting() {
        JDBCDatastoreProperties datastoreProperties = this.getDatastoreProperties();
        this.setting.setDriverPaths(datastoreProperties.getCurrentDriverPaths());
        this.setting.setDriverClass(datastoreProperties.getCurrentDriverClass());
        this.setting.setJdbcUrl((String)datastoreProperties.jdbcUrl.getValue());
        this.setting.setUsername((String)datastoreProperties.userId.getValue());
        this.setting.setPassword((String)datastoreProperties.password.getValue());
        this.setting.setSchema((Schema)this.main.schema.getValue());
        this.setting.setSql(this.getSql());
        if (this.sourceType.getValue() == SourceType.TABLE_NAME) {
            this.setting.setTablename((String)this.tableName.getValue());
        }
        return this.setting;
    }

    public String getSql() {
        if (this.sourceType.getValue() == SourceType.TABLE_NAME) {
            return "select * from " + (String)this.tableName.getValue();
        }
        return CommonUtils.validateQuery((String)this.sql.getValue());
    }

    public static enum SourceType {
        TABLE_NAME,
        QUERY;

    }
}

