/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.talend.components.api.component.runtime.DependenciesReader;
import org.talend.components.api.component.runtime.JarRuntimeInfo;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.jdbc.JDBCFamilyDefinition;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;

public class JdbcRuntimeInfo
extends JarRuntimeInfo {
    private final RuntimeSettingProvider props;
    private final String driverClassName;

    public JdbcRuntimeInfo(RuntimeSettingProvider props, String runtimeClassName) {
        this(props, JDBCFamilyDefinition.getDIRuntimeMavenURI(), DependenciesReader.computeDependenciesFilePath((String)JDBCFamilyDefinition.getDIRuntimeGroupId(), (String)JDBCFamilyDefinition.getDIRuntimeArtifactId()), runtimeClassName);
    }

    public JdbcRuntimeInfo(RuntimeSettingProvider props, String jarUrlString, String depTxtPath, String runtimeClassName) {
        super(jarUrlString, depTxtPath, runtimeClassName, true);
        if (props == null) {
            throw new NullPointerException("props must not be null");
        }
        this.props = props;
        this.driverClassName = props.getRuntimeSetting().getDriverClass();
    }

    public JdbcRuntimeInfo cloneWithNewJarUrlString(String newJarUrlString) {
        return new JdbcRuntimeInfo(this.props, newJarUrlString, this.getDepTxtPath(), this.getRuntimeClassName());
    }

    public List<URL> getMavenUrlDependencies() {
        ArrayList<URL> dependencies = new ArrayList<URL>(super.getMavenUrlDependencies());
        dependencies.addAll(this.getDriverDependencies());
        return dependencies;
    }

    private List<URL> getDriverDependencies() {
        try {
            ArrayList<URL> driverUrls = new ArrayList<URL>();
            List<String> driverPaths = this.props.getRuntimeSetting().getDriverPaths();
            if (driverPaths != null) {
                for (String driver : driverPaths) {
                    String mavenPath = this.removeQuote(driver);
                    if (mavenPath == null || mavenPath.length() <= 0 || "newLine".equals(mavenPath)) continue;
                    driverUrls.add(new URL(mavenPath));
                }
            }
            return driverUrls;
        }
        catch (MalformedURLException e) {
            throw new ComponentException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
        }
    }

    String removeQuote(String content) {
        if (content.startsWith("\"") && content.endsWith("\"")) {
            return content.substring(1, content.length() - 1);
        }
        return content;
    }

    public String toString() {
        return super.toString() + ", JdbcRuntimeInfo: {driverClassName:" + this.driverClassName + "}";
    }
}

