/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.components.api.component.Connector;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.api.properties.ComponentReferenceProperties;
import org.talend.components.common.config.jdbc.Dbms;
import org.talend.components.common.config.jdbc.MappingFileLoader;
import org.talend.components.jdbc.module.DBTypes;
import org.talend.components.jdbc.module.JDBCConnectionModule;
import org.talend.components.jdbc.query.EDatabase4DriverClassName;
import org.talend.components.jdbc.query.EDatabaseTypeName;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.tjdbcconnection.TJDBCConnectionProperties;
import org.talend.components.jdbc.validation.QueryValidator;
import org.talend.components.jdbc.validation.QueryValidatorFactory;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.property.Property;

public class CommonUtils {
    private static Map<String, String> productValue2DefaultMappingFileSubfix = new HashMap<String, String>();
    private static Map<DBTypes, String> dbType2MappingFileSubfix = new HashMap<DBTypes, String>();

    public static Form addForm(Properties props, String formName) {
        return new Form(props, formName);
    }

    public static Schema getMainSchemaFromOutputConnector(ComponentProperties properties) {
        return CommonUtils.getOutputSchema(properties);
    }

    public static Schema getMainSchemaFromInputConnector(ComponentProperties properties) {
        Set inputConnectors = properties.getPossibleConnectors(false);
        if (inputConnectors == null) {
            return null;
        }
        for (Connector connector : inputConnectors) {
            if (!"MAIN".equals(connector.getName())) continue;
            return properties.getSchema(connector, false);
        }
        return null;
    }

    public static Schema getOutputSchema(ComponentProperties properties) {
        Set outputConnectors = properties.getPossibleConnectors(true);
        if (outputConnectors == null) {
            return null;
        }
        for (Connector connector : outputConnectors) {
            if (!"MAIN".equals(connector.getName())) continue;
            return properties.getSchema(connector, true);
        }
        return null;
    }

    public static Schema getRejectSchema(ComponentProperties properties) {
        Set outputConnectors = properties.getPossibleConnectors(true);
        if (outputConnectors == null) {
            return null;
        }
        for (Connector connector : outputConnectors) {
            if (!"REJECT".equals(connector.getName())) continue;
            return properties.getSchema(connector, true);
        }
        return null;
    }

    public static Schema newSchema(Schema metadataSchema, String newSchemaName, List<Schema.Field> moreFields) {
        return CommonUtils.newSchema(metadataSchema, newSchemaName, moreFields, Integer.MAX_VALUE);
    }

    public static Schema newSchema(Schema metadataSchema, String newSchemaName, List<Schema.Field> moreFields, int insertPoint) {
        Schema newSchema = Schema.createRecord((String)newSchemaName, (String)metadataSchema.getDoc(), (String)metadataSchema.getNamespace(), (boolean)metadataSchema.isError());
        List fields = metadataSchema.getFields();
        boolean removeDuplicatedNameField = insertPoint == Integer.MAX_VALUE;
        List<Schema.Field> copyFieldList = CommonUtils.cloneFieldsAndResetPosition(fields, removeDuplicatedNameField, moreFields);
        if (removeDuplicatedNameField) {
            copyFieldList.addAll(moreFields);
        } else {
            copyFieldList.addAll(insertPoint, moreFields);
        }
        newSchema.setFields(copyFieldList);
        for (Map.Entry entry : metadataSchema.getObjectProps().entrySet()) {
            newSchema.addProp((String)entry.getKey(), entry.getValue());
        }
        return newSchema;
    }

    private static List<Schema.Field> cloneFieldsAndResetPosition(List<Schema.Field> fields, boolean removeDuplicatedNameField, List<Schema.Field> more) {
        ArrayList<Schema.Field> copyFieldList = new ArrayList<Schema.Field>();
        HashSet<String> moreFieldNames = new HashSet<String>();
        if (removeDuplicatedNameField && more != null && !more.isEmpty()) {
            for (Schema.Field field : more) {
                moreFieldNames.add(field.name());
            }
        }
        for (Schema.Field se : fields) {
            if (moreFieldNames.contains(se.name())) continue;
            Schema.Field field = new Schema.Field(se.name(), se.schema(), se.doc(), se.defaultVal(), se.order());
            field.getObjectProps().putAll(se.getObjectProps());
            for (Map.Entry entry : se.getObjectProps().entrySet()) {
                field.addProp((String)entry.getKey(), entry.getValue());
            }
            copyFieldList.add(field);
        }
        return copyFieldList;
    }

    public static Schema mergeRuntimeSchema2DesignSchema4Dynamic(Schema designSchema, Schema runtimeSchema) {
        int dynPosition = Integer.valueOf(designSchema.getProp("di.dynamic.column.position"));
        List designFields = designSchema.getFields();
        List runtimeFields = runtimeSchema.getFields();
        int dynamcStartColumnPostion = dynPosition;
        int dynamcEndColumnPostion = dynPosition + runtimeFields.size() - designFields.size();
        HashSet<String> designFieldSet = new HashSet<String>();
        for (Schema.Field designField : designFields) {
            String oname = designField.getProp("talend.field.dbColumnName");
            designFieldSet.add(oname);
        }
        List<Schema.Field> dynamicFields = new ArrayList<Schema.Field>();
        for (int i = dynamcStartColumnPostion; i < dynamcEndColumnPostion; ++i) {
            Schema.Field runtimeField = (Schema.Field)runtimeFields.get(i);
            String oname = runtimeField.getProp("talend.field.dbColumnName");
            if (designFieldSet.contains(oname)) continue;
            dynamicFields.add(runtimeField);
        }
        dynamicFields = CommonUtils.cloneFieldsAndResetPosition(dynamicFields, false, null);
        return CommonUtils.newSchema(designSchema, designSchema.getName(), dynamicFields, dynPosition);
    }

    public static void setCommonConnectionInfo(AllSetting setting, JDBCConnectionModule connection) {
        if (connection == null) {
            return;
        }
        setting.setDriverPaths(connection.driverTable.drivers.getValue());
        setting.setDriverClass((String)connection.driverClass.getValue());
        setting.setJdbcUrl((String)connection.jdbcUrl.getValue());
        setting.setUsername((String)connection.userPassword.userId.getValue());
        setting.setPassword((String)connection.userPassword.password.getValue());
    }

    public static boolean setReferenceInfo(AllSetting setting, ComponentReferenceProperties<TJDBCConnectionProperties> referencedComponent) {
        if (referencedComponent == null) {
            return false;
        }
        boolean useOtherConnection = CommonUtils.useExistedConnection(referencedComponent);
        if (useOtherConnection) {
            setting.setReferencedComponentId((String)referencedComponent.componentInstanceId.getValue());
            setting.setReferencedComponentProperties((ComponentProperties)referencedComponent.getReference());
            return true;
        }
        return false;
    }

    public static boolean useExistedConnection(ComponentReferenceProperties<TJDBCConnectionProperties> referencedComponent) {
        String refComponentIdValue = referencedComponent.componentInstanceId.getStringValue();
        ComponentReferenceProperties.ReferenceType referenceType = (ComponentReferenceProperties.ReferenceType)referencedComponent.referenceType.getValue();
        boolean useOtherConnection = refComponentIdValue != null && (refComponentIdValue.startsWith("tJDBCConnection") || referenceType != null && referenceType == ComponentReferenceProperties.ReferenceType.COMPONENT_INSTANCE);
        return useOtherConnection;
    }

    public static void setReferenceInfoAndConnectionInfo(AllSetting setting, ComponentReferenceProperties<TJDBCConnectionProperties> referencedComponent, JDBCConnectionModule connection) {
        boolean useExistedConnection = CommonUtils.setReferenceInfo(setting, referencedComponent);
        if (useExistedConnection) {
            if (referencedComponent.getReference() != null) {
                CommonUtils.setCommonConnectionInfo(setting, ((TJDBCConnectionProperties)referencedComponent.getReference()).connection);
            }
        } else {
            CommonUtils.setCommonConnectionInfo(setting, connection);
        }
    }

    public static List<String> getAllSchemaFieldNames(Schema schema) {
        ArrayList<String> values = new ArrayList<String>();
        if (schema == null) {
            return values;
        }
        for (Schema.Field field : schema.getFields()) {
            values.add(field.name());
        }
        return values;
    }

    public static String validateQuery(String query, QueryValidatorFactory.ValidationType validationType) {
        QueryValidator validator = QueryValidatorFactory.createValidator(validationType);
        if (query == null || query.isEmpty() || validator.isValid(query)) {
            return query;
        }
        throw TalendRuntimeException.createUnexpectedException((String)"Please check your sql as we only allow the query which don't do write or lock action.");
    }

    public static String validateQuery(String query) {
        return CommonUtils.validateQuery(query, QueryValidatorFactory.ValidationType.CALCITE);
    }

    public static List<String> getAllSchemaFieldDBNames(Schema schema) {
        ArrayList<String> values = new ArrayList<String>();
        if (schema == null) {
            return values;
        }
        for (Schema.Field field : schema.getFields()) {
            values.add(field.getProp("talend.field.dbColumnName"));
        }
        return values;
    }

    public static String getStudioNameFromProperty(String inputString) {
        StringBuilder result = new StringBuilder();
        if (inputString == null || inputString.isEmpty()) {
            return inputString;
        }
        for (int i = 0; i < inputString.length(); ++i) {
            Character c = Character.valueOf(inputString.charAt(i));
            result.append(Character.isUpperCase(c.charValue()) && i > 0 ? "_" + c : c);
        }
        return result.toString().toUpperCase(Locale.ENGLISH);
    }

    public static Schema.Field getField(Schema schema, String fieldName) {
        if (schema == null) {
            return null;
        }
        for (Schema.Field outField : schema.getFields()) {
            if (!outField.name().equals(fieldName)) continue;
            return outField;
        }
        return null;
    }

    public static String getRealDBType(AllSetting setting, String dbType) {
        if (dbType == null || dbType.equals(EDatabaseTypeName.GENERAL_JDBC.getDisplayName())) {
            String driverClassName = setting.getDriverClass();
            if ("com.sybase.jdbc3.jdbc.SybDataSource".equals(driverClassName)) {
                driverClassName = EDatabase4DriverClassName.SYBASEASE.getDriverClass();
            }
            List<String> driverPaths = setting.getDriverPaths();
            StringBuilder sb = new StringBuilder();
            for (String path : driverPaths) {
                sb.append(path);
            }
            String driverJarInfo = sb.toString();
            dbType = CommonUtils.getDbTypeByClassNameAndDriverJar(driverClassName, driverJarInfo);
            if (dbType == null) {
                dbType = EDatabaseTypeName.ORACLE_OCI.getDisplayName();
            }
        }
        return dbType;
    }

    public static Dbms getMapping(URL mappingFilesDir, AllSetting setting, String dbTypeByComponentType, DBTypes dbTypeInComponentSetting) {
        File mappingFileFullPath;
        String realDbType = CommonUtils.getRealDBType(setting, dbTypeByComponentType);
        String product = EDatabaseTypeName.getTypeFromDisplayName(realDbType).getProduct();
        String mappingFileSubfix = productValue2DefaultMappingFileSubfix.get(product);
        if (dbTypeInComponentSetting != null && mappingFileSubfix == null) {
            mappingFileSubfix = dbType2MappingFileSubfix.get((Object)dbTypeInComponentSetting);
        }
        if (mappingFileSubfix == null) {
            mappingFileSubfix = "Mysql";
        }
        if (!(mappingFileFullPath = new File(mappingFilesDir.getFile(), "mapping_" + mappingFileSubfix + ".xml")).exists()) {
            mappingFileFullPath = new File(mappingFilesDir.getFile(), "mapping_" + mappingFileSubfix.toLowerCase() + ".xml");
        }
        MappingFileLoader fileLoader = new MappingFileLoader();
        List dbmsList = fileLoader.load(mappingFileFullPath);
        Dbms dbms = (Dbms)dbmsList.get(0);
        return dbms;
    }

    public static Dbms getMapping(String mappingFilesDir, AllSetting setting, String dbTypeByComponentType, DBTypes dbTypeInComponentSetting) {
        try {
            return CommonUtils.getMapping(new URL(mappingFilesDir), setting, dbTypeByComponentType, dbTypeInComponentSetting);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("can't find the mapping file dir : " + mappingFilesDir);
        }
    }

    private static String getDbTypeByClassNameAndDriverJar(String driverClassName, String driverJar) {
        List<EDatabase4DriverClassName> t4d = EDatabase4DriverClassName.indexOfByDriverClass(driverClassName);
        if (t4d.size() == 1) {
            return t4d.get(0).getDbTypeName();
        }
        if (t4d.size() > 1) {
            if (driverJar == null || "".equals(driverJar) || !driverJar.contains(".jar")) {
                return t4d.get(0).getDbTypeName();
            }
            if (driverJar.contains("postgresql-8.3-603.jdbc3.jar") || driverJar.contains("postgresql-8.3-603.jdbc4.jar") || driverJar.contains("postgresql-8.3-603.jdbc2.jar")) {
                return EDatabase4DriverClassName.PSQL.getDbTypeName();
            }
            return t4d.get(0).getDbTypeName();
        }
        return null;
    }

    public static void updatePossibleValues(Property<String> property, List<String> possibleValues) {
        property.setPossibleValues(possibleValues);
        String oldValue = (String)property.getValue();
        if (possibleValues != null && !possibleValues.isEmpty() && !possibleValues.contains(oldValue)) {
            property.setStoredValue((Object)possibleValues.get(0));
        } else if (possibleValues == null || possibleValues.isEmpty()) {
            property.setStoredValue(null);
        }
    }

    public static String getClearExceptionInfo(Exception e) {
        if (e.getCause() != null) {
            return CommonUtils.correctExceptionInfo(e.getCause());
        }
        return CommonUtils.correctExceptionInfo(e);
    }

    public static String correctExceptionInfo(Throwable e) {
        if (e instanceof ClassNotFoundException) {
            return "can't find the jdbc driver class : \"" + e.getMessage() + "\"";
        }
        String message = e.getMessage();
        if (message == null || message.isEmpty()) {
            return e.getClass().getName();
        }
        return message;
    }

    public static ComponentException newComponentException(Throwable cause) {
        ExceptionContext context = CommonUtils.createExceptionContext(cause);
        return new ComponentException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, cause, context);
    }

    public static ComponentException newComponentException(ErrorCode errorCode, Throwable cause) {
        ExceptionContext context = CommonUtils.createExceptionContext(cause);
        return new ComponentException(errorCode, cause, context);
    }

    public static ComponentException newComponentException(ErrorCode errorCode, ExceptionContext context) {
        return new ComponentException(errorCode, context);
    }

    public static ComponentException newComponentException(ErrorCode errorCode, Throwable cause, ExceptionContext context) {
        return new ComponentException(errorCode, cause, context);
    }

    private static ExceptionContext createExceptionContext(Throwable cause) {
        String message = CommonUtils.correctExceptionInfo(cause);
        return ExceptionContext.build().put("message", (Object)message);
    }

    static {
        dbType2MappingFileSubfix.put(DBTypes.AS400, "AS400");
        dbType2MappingFileSubfix.put(DBTypes.ACCESS, "Access");
        dbType2MappingFileSubfix.put(DBTypes.DB2, "IBMDB2");
        dbType2MappingFileSubfix.put(DBTypes.FIREBIRD, "Firebird");
        dbType2MappingFileSubfix.put(DBTypes.HSQLDB, "HSQLDB");
        dbType2MappingFileSubfix.put(DBTypes.INFORMIX, "Informix");
        dbType2MappingFileSubfix.put(DBTypes.INGRES, "Ingres");
        dbType2MappingFileSubfix.put(DBTypes.VECTORWISE, "VectorWise");
        dbType2MappingFileSubfix.put(DBTypes.INTERBASE, "Interbase");
        dbType2MappingFileSubfix.put(DBTypes.JAVADB, "JavaDB");
        dbType2MappingFileSubfix.put(DBTypes.MAXDB, "MaxDB");
        dbType2MappingFileSubfix.put(DBTypes.MSSQL, "MSSQL");
        dbType2MappingFileSubfix.put(DBTypes.MYSQL, "Mysql");
        dbType2MappingFileSubfix.put(DBTypes.NETEZZA, "Netezza");
        dbType2MappingFileSubfix.put(DBTypes.ORACLE, "Oracle");
        dbType2MappingFileSubfix.put(DBTypes.POSTGRESQL, "Postgres");
        dbType2MappingFileSubfix.put(DBTypes.POSTGREPLUS, "PostgresPlus");
        dbType2MappingFileSubfix.put(DBTypes.SQLITE, "SQLite");
        dbType2MappingFileSubfix.put(DBTypes.SYBASE, "Sybase");
        dbType2MappingFileSubfix.put(DBTypes.SAPHANA, "SAPHana");
        dbType2MappingFileSubfix.put(DBTypes.TERADATA, "Teradata");
        dbType2MappingFileSubfix.put(DBTypes.VERTICA, "Vertica");
        dbType2MappingFileSubfix.put(DBTypes.H2, "H2");
        dbType2MappingFileSubfix.put(DBTypes.ODBC, "MSODBC");
        productValue2DefaultMappingFileSubfix.put("ACCESS", "Access");
        productValue2DefaultMappingFileSubfix.put("AS400", "AS400");
        productValue2DefaultMappingFileSubfix.put("BIGQUERY", "BigQuery");
        productValue2DefaultMappingFileSubfix.put("Cassandra", "Cassandra");
        productValue2DefaultMappingFileSubfix.put("Exasol", "Exasol");
        productValue2DefaultMappingFileSubfix.put("FIREBIRD", "Firebird");
        productValue2DefaultMappingFileSubfix.put("GREENPLUM", "Greenplum");
        productValue2DefaultMappingFileSubfix.put("H2", "H2");
        productValue2DefaultMappingFileSubfix.put("HIVE", "Hive");
        productValue2DefaultMappingFileSubfix.put("HSQLDB", "HSQLDB");
        productValue2DefaultMappingFileSubfix.put("IBM_DB2", "IBMDB2");
        productValue2DefaultMappingFileSubfix.put("IMPALA", "Impala");
        productValue2DefaultMappingFileSubfix.put("INFORMIX", "Informix");
        productValue2DefaultMappingFileSubfix.put("INGRES", "Ingres");
        productValue2DefaultMappingFileSubfix.put("INTERBASE", "Interbase");
        productValue2DefaultMappingFileSubfix.put("JAVADB", "JavaDB");
        productValue2DefaultMappingFileSubfix.put("MAXDB", "MaxDB");
        productValue2DefaultMappingFileSubfix.put("ODBC", "MsOdbc");
        productValue2DefaultMappingFileSubfix.put("SQL_SERVER", "MSSQL");
        productValue2DefaultMappingFileSubfix.put("MYSQL", "Mysql");
        productValue2DefaultMappingFileSubfix.put("NETEZZA", "Netezza");
        productValue2DefaultMappingFileSubfix.put("ORACLE", "Oracle");
        productValue2DefaultMappingFileSubfix.put("PARACCEL", "ParAccel");
        productValue2DefaultMappingFileSubfix.put("POSTGRESQL", "Postgres");
        productValue2DefaultMappingFileSubfix.put("POSTGRESPLUS", "PostgresPlus");
        productValue2DefaultMappingFileSubfix.put("REDSHIFT", "Redshift");
        productValue2DefaultMappingFileSubfix.put("SAPHANA", "SAPHana");
        productValue2DefaultMappingFileSubfix.put("SNOWFLAKE", "Snowflake");
        productValue2DefaultMappingFileSubfix.put("SQLITE", "SQLite");
        productValue2DefaultMappingFileSubfix.put("SYBASE", "Sybase");
        productValue2DefaultMappingFileSubfix.put("TERADATA", "Teradata");
        productValue2DefaultMappingFileSubfix.put("VECTORWISE", "VectorWise");
        productValue2DefaultMappingFileSubfix.put("VERTICA", "Vertica");
    }
}

