/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.writers;

import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.setting.ProgramSettings;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.util.OutputHelper;
import cz.drg.clasificator.util.StringUtil;
import cz.drg.clasificator.writers.BaseWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CsvWriter
extends BaseWriter {
    private static String DEFAULT_CHARSET;
    private static String DEFAULT_DELIMITER;
    private static String DEFAULT_OUTPUT_FILEPATH;
    private static File DEFAULT_OUTPUT;
    private File target;
    private Charset charset;
    private boolean alreadyWrittenTo = false;

    public CsvWriter(File target, String delimiter, String charset) {
        super(delimiter);
        this.target = target;
        this.charset = Charset.forName(charset);
    }

    public CsvWriter(String filePath, String delimiter, String charset) {
        this(new File(filePath), delimiter, charset);
    }

    public CsvWriter(String filePath, String delimiter) {
        this(new File(filePath), delimiter, DEFAULT_CHARSET);
    }

    public CsvWriter(String filePath) {
        this(new File(filePath), DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }

    public CsvWriter() {
        this(DEFAULT_OUTPUT, DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }

    private static void loadDefaults() {
        ProgramSettings programSettings = Settings.getProgramSettings();
        DEFAULT_CHARSET = programSettings.getDefaultCharset();
        DEFAULT_DELIMITER = StringUtil.unescapeJavaString(programSettings.getDefaultDelimiter());
        DEFAULT_OUTPUT_FILEPATH = programSettings.getDefaultOutputPath();
    }

    @Override
    public void writeOutput(List<String> lines) {
        if (this.alreadyWrittenTo) {
            lines.remove(0);
        }
        StringBuilder sb = new StringBuilder();
        lines.stream().forEach(value -> {
            sb.append((String)value);
            sb.append(System.lineSeparator());
        });
        try {
            Files.write(this.target.toPath(), sb.toString().getBytes(this.charset), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            this.alreadyWrittenTo = true;
        }
        catch (IOException ex) {
            Logger.getLogger(CsvWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void clear() {
        try {
            Files.deleteIfExists(this.target.toPath());
            this.alreadyWrittenTo = false;
        }
        catch (IOException ex) {
            OutputHelper.dualLog(ex.getMessage());
            throw new ShutdownException("Error when deleting old file entries.");
        }
    }

    @Override
    public void close() {
    }

    static {
        CsvWriter.loadDefaults();
        DEFAULT_OUTPUT = new File(DEFAULT_OUTPUT_FILEPATH);
    }
}

