/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.util.FilesCache;
import cz.drg.clasificator.util.JacksonUtil;
import cz.drg.clasificator.util.UnmarshallNormaly;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Row;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnmarshallOptimized {
    private ExecutorService pool;
    private static final String SIMPLIFIED_PMML_FOLDERPATH = "./log/";
    private static final String SIMPLIFIED_PMML_FILEPATH = "./log/editedModelCopy" + System.currentTimeMillis() + ".xml";

    public UnmarshallOptimized() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.pool = new ThreadPoolExecutor(availableProcessors, availableProcessors, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public PMML unmarshal(ZipFile pmmlFile) {
        PMML pmml = this.startOptimizedUnmarshaling(pmmlFile);
        this.pool.shutdown();
        try {
            Files.deleteIfExists(Paths.get(SIMPLIFIED_PMML_FILEPATH, new String[0]));
            FilesCache.freeRemovedFile(SIMPLIFIED_PMML_FILEPATH);
        }
        catch (IOException ex) {
            Logger.getLogger(UnmarshallOptimized.class.getName()).log(Level.SEVERE, null, ex);
        }
        return pmml;
    }

    private PMML startOptimizedUnmarshaling(ZipFile pmmlFile) {
        List<String> defineFunctionsWithInlineTables = this.createSimplifiedPmmlFile(pmmlFile);
        List<Future> paralelUnmarshalTasks = this.startParalelProcessing(defineFunctionsWithInlineTables);
        PMML pmml = new UnmarshallNormaly().unmarshal(new File(SIMPLIFIED_PMML_FILEPATH));
        this.waitTillAllTasksFinished(paralelUnmarshalTasks);
        this.replaceDefineFunctions(pmml, paralelUnmarshalTasks);
        return pmml;
    }

    private void ensureSimplifiedPmmlFile() {
        File editedPmmlCopy = new File(SIMPLIFIED_PMML_FILEPATH);
        File logFolder = new File(SIMPLIFIED_PMML_FOLDERPATH);
        editedPmmlCopy.delete();
        FilesCache.freeRemovedFile(SIMPLIFIED_PMML_FILEPATH);
        try {
            logFolder.mkdirs();
            editedPmmlCopy.createNewFile();
            FilesCache.addCreatedFile(SIMPLIFIED_PMML_FILEPATH);
        }
        catch (IOException ex) {
            Logger.getLogger(UnmarshallOptimized.class.getName()).log(Level.SEVERE, null, ex);
            throw new ShutdownException(String.format("Cannot create file '%s'.", SIMPLIFIED_PMML_FILEPATH));
        }
    }

    private List<String> createSimplifiedPmmlFile(ZipFile pmmlFile) {
        ArrayList<String> defineFunctionsWithInlineTables = new ArrayList<String>();
        this.ensureSimplifiedPmmlFile();
        ZipEntry pmmlModel = pmmlFile.entries().nextElement();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(pmmlFile.getInputStream(pmmlModel)));){
            List readLines = br.lines().collect(Collectors.toList());
            boolean defineFunction = false;
            boolean hasInlineTable = false;
            StringBuilder sb = null;
            ArrayList<String> batchWrite = new ArrayList<String>();
            for (String row : readLines) {
                if (!defineFunction) {
                    batchWrite.add(row);
                }
                if (row.contains("<DefineFunction")) {
                    defineFunction = true;
                    sb = new StringBuilder(row.replaceFirst(">", " xmlns=\"http://www.dmg.org/PMML-4_3\">"));
                    sb.append("\n");
                    batchWrite.remove(batchWrite.size() - 1);
                    Files.write(Paths.get(SIMPLIFIED_PMML_FILEPATH, new String[0]), batchWrite, StandardOpenOption.APPEND);
                    batchWrite.clear();
                } else if (row.contains("</DefineFunction>")) {
                    defineFunction = false;
                    sb.append(row);
                    if (hasInlineTable) {
                        String defineFunctionXml = sb.toString();
                        String replacement = this.emptyInlineTable(defineFunctionXml);
                        Files.write(Paths.get(SIMPLIFIED_PMML_FILEPATH, new String[0]), replacement.getBytes(), StandardOpenOption.APPEND);
                        defineFunctionsWithInlineTables.add(sb.toString());
                    } else {
                        Files.write(Paths.get(SIMPLIFIED_PMML_FILEPATH, new String[0]), sb.toString().getBytes(), StandardOpenOption.APPEND);
                    }
                    hasInlineTable = false;
                    sb = null;
                } else if (defineFunction) {
                    sb.append(row);
                }
                if (!row.contains("<InlineTable>")) continue;
                hasInlineTable = true;
            }
            Files.write(Paths.get(SIMPLIFIED_PMML_FILEPATH, new String[0]), batchWrite, StandardOpenOption.APPEND);
            batchWrite.clear();
        }
        catch (IOException ex) {
            Logger.getLogger(UnmarshallOptimized.class.getName()).log(Level.SEVERE, null, ex);
        }
        return defineFunctionsWithInlineTables;
    }

    private String emptyInlineTable(String defineFunctionXml) {
        int endOfFirstRow = defineFunctionXml.indexOf("</row>");
        int endOfInlineTable = defineFunctionXml.indexOf("</InlineTable>");
        String firstLineIncluded = defineFunctionXml.substring(0, endOfFirstRow + 6);
        String closures = defineFunctionXml.substring(endOfInlineTable);
        String replacement = firstLineIncluded.concat(closures);
        return replacement;
    }

    private void waitTillAllTasksFinished(List<Future> paralelUnmarshalTasks) {
        boolean finished = false;
        while (!finished) {
            try {
                Thread.sleep(50L);
                finished = true;
                for (Future paralelUnmarshalTask : paralelUnmarshalTasks) {
                    if (paralelUnmarshalTask.isDone()) continue;
                    finished = false;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(UnmarshallOptimized.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void replaceDefineFunctions(PMML pmml, List<Future> paralelUnmarshalTasks) {
        List<DefineFunction> defineFunctions = pmml.getTransformationDictionary().getDefineFunctions();
        for (Future paralelUnmarshalTask : paralelUnmarshalTasks) {
            try {
                DefineFunction function = (DefineFunction)paralelUnmarshalTask.get();
                for (int i = 0; i < defineFunctions.size(); ++i) {
                    DefineFunction simpleFunction = defineFunctions.get(i);
                    if (!simpleFunction.getName().equals(function.getName())) continue;
                    defineFunctions.set(i, function);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(UnmarshallOptimized.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private List<Future> startParalelProcessing(List<String> defineFunctionsWithInlineTables) {
        ArrayList<Future> paralelUnmarshalTasks = new ArrayList<Future>();
        for (String defineFunctionsWithInlineTable : defineFunctionsWithInlineTables) {
            paralelUnmarshalTasks.add(this.pool.submit(new UnmarshallDefineFunction(defineFunctionsWithInlineTable)));
        }
        return paralelUnmarshalTasks;
    }

    private class UnmarshallInlineTable
    implements Callable<InlineTable> {
        private final String xmlData;
        private final String inlineTableTag = "<InlineTable>";
        private final int inlineTableTagLength = "<InlineTable>".length();
        private final String inlineTableEndTag = "</InlineTable>";
        private final int inlineTableEndTagLength = "</InlineTable>".length();
        private final String rowTag = "<row>";
        private final int rowTagLength = "<row>".length();
        private final String rowEndTag = "</row>";
        private final int rowEndTagLength = "</row>".length();

        public UnmarshallInlineTable(String xmlData) {
            this.xmlData = xmlData;
        }

        @Override
        public InlineTable call() throws Exception {
            InlineTable table = this.unmarshalCustom();
            return table;
        }

        private InlineTable unmarshalCustom() {
            int rowStartIndex;
            InlineTable table = new InlineTable();
            String rowsOnly = this.xmlData.substring(this.inlineTableTagLength, this.xmlData.length() - this.inlineTableEndTagLength);
            rowsOnly = rowsOnly.replaceAll("<content>", "").replaceAll("</content>", "");
            int offset = 0;
            while (offset < rowsOnly.length() && (rowStartIndex = rowsOnly.indexOf("<row>", offset)) != -1) {
                int rowEndIndex = rowsOnly.indexOf("</row>", rowStartIndex + this.rowTagLength);
                int contentStartIndex = rowStartIndex + this.rowTagLength;
                int contentEndIndex = rowEndIndex;
                Row row = new Row();
                this.fillRow(row, rowsOnly.substring(contentStartIndex, contentEndIndex));
                table.addRows(row);
                offset = rowEndIndex + this.rowEndTagLength;
            }
            return table;
        }

        private void fillRow(Row row, String substring) {
            try {
                int startTagIndex;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document parentDOM = builder.newDocument();
                int offset = 0;
                while ((startTagIndex = substring.indexOf("<", offset)) != -1) {
                    String tagContent;
                    int closeTagEnd;
                    String tagName;
                    int endTagIndex = substring.indexOf(">", offset + 1);
                    if (substring.charAt(endTagIndex - 1) == '/') {
                        tagName = substring.substring(startTagIndex + 1, endTagIndex - 1);
                        closeTagEnd = endTagIndex;
                        tagContent = "0";
                    } else {
                        tagName = substring.substring(startTagIndex + 1, endTagIndex);
                        int closeTagStart = substring.indexOf("<", endTagIndex + 1);
                        closeTagEnd = substring.indexOf(">", endTagIndex + 1);
                        tagContent = substring.substring(endTagIndex + 1, closeTagStart);
                    }
                    offset = closeTagEnd;
                    Element parent = parentDOM.createElement(tagName);
                    parent.setTextContent(tagContent);
                    row.addContent(parent);
                }
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(UnmarshallOptimized.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private class UnmarshallDefineFunction
    implements Callable<DefineFunction> {
        private final String xmlData;
        private ExecutorService defineFunctionPool;
        private final String inlineTableTag = "<InlineTable>";
        private final int inlineTableTagLength = "<InlineTable>".length();
        private final String inlineTableEndTag = "</InlineTable>";
        private final int inlineTableEndTagLength = "</InlineTable>".length();
        private final String rowEndTag = "</row>";
        private final int rowEndTagLength = "</row>".length();

        public UnmarshallDefineFunction(String xmlData) {
            this.xmlData = xmlData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DefineFunction call() throws Exception {
            DefineFunction function = null;
            boolean tooLargeInlineTable = false;
            try {
                int inlineTableTagIndex = this.xmlData.indexOf("<InlineTable>");
                int inlineTableEndTagIndex = this.xmlData.indexOf("</InlineTable>");
                int firstRowEndTagIndex = this.xmlData.indexOf("</row>");
                int endFirstRowIndexTag = firstRowEndTagIndex + this.rowEndTagLength;
                int endInlineTableTagIndex = inlineTableTagIndex + this.inlineTableTagLength;
                int rowLength = endFirstRowIndexTag - endInlineTableTagIndex;
                int totalRowLength = inlineTableEndTagIndex + this.inlineTableEndTagLength - inlineTableTagIndex - this.inlineTableTagLength - this.inlineTableEndTagLength;
                int estimatedRows = totalRowLength / rowLength;
                if (estimatedRows > 10000) {
                    tooLargeInlineTable = true;
                    int availableProcessors = 1;
                    this.defineFunctionPool = new ThreadPoolExecutor(availableProcessors, availableProcessors, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                    ArrayList<Future<InlineTable>> inlineTableTasks = new ArrayList<Future<InlineTable>>();
                    String withoutInlineTableTag = this.xmlData.substring(inlineTableTagIndex + this.inlineTableTagLength, inlineTableEndTagIndex);
                    int previousOffset = 0;
                    int numberOfRowsPerTask = 10000;
                    int lastRowGroup = totalRowLength / (rowLength * numberOfRowsPerTask);
                    for (int i = 0; i <= lastRowGroup; ++i) {
                        int beginAt = i * rowLength * numberOfRowsPerTask - previousOffset;
                        int substringTo = (i + 1) * rowLength * numberOfRowsPerTask > withoutInlineTableTag.length() ? withoutInlineTableTag.length() : (i + 1) * rowLength * numberOfRowsPerTask;
                        String string = withoutInlineTableTag.substring(beginAt, substringTo);
                        int n = string.lastIndexOf("</row>") + this.rowEndTagLength;
                        previousOffset = string.length() - n;
                        String string2 = string.substring(0, n);
                        String splittedInlineTable = this.inlineTableTag.concat(string2).concat(this.inlineTableEndTag);
                        splittedInlineTable = splittedInlineTable.replaceFirst(">", " xmlns=\"http://www.dmg.org/PMML-4_3\">");
                        inlineTableTasks.add(this.defineFunctionPool.submit(new UnmarshallInlineTable(splittedInlineTable)));
                    }
                    String functionWithoutRows = this.xmlData.substring(0, endInlineTableTagIndex);
                    functionWithoutRows = functionWithoutRows.concat(this.xmlData.substring(this.xmlData.indexOf("</InlineTable>")));
                    function = this.unmarshalData(functionWithoutRows);
                    boolean allFinished = false;
                    block4: while (!allFinished) {
                        Thread.sleep(400L);
                        allFinished = true;
                        for (Future future : inlineTableTasks) {
                            if (future.isDone()) continue;
                            allFinished = false;
                            continue block4;
                        }
                    }
                    InlineTable completeTable = new InlineTable();
                    for (Future future : inlineTableTasks) {
                        InlineTable table = (InlineTable)future.get();
                        completeTable.getRows().addAll(table.getRows());
                    }
                    MapValues mapValues = (MapValues)function.getExpression();
                    mapValues.setInlineTable(completeTable);
                }
                if (!tooLargeInlineTable) {
                    function = this.unmarshalData(this.xmlData);
                }
            }
            finally {
                if (this.defineFunctionPool != null) {
                    this.defineFunctionPool.shutdown();
                }
            }
            return function;
        }

        private DefineFunction unmarshalData(String functionData) {
            DefineFunction function = null;
            try {
                function = (DefineFunction)JacksonUtil.mapper().readValue(functionData, DefineFunction.class);
            }
            catch (IOException ex) {
                Logger.getLogger(UnmarshallOptimized.class.getName()).log(Level.SEVERE, null, ex);
            }
            return function;
        }
    }
}

