/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import cz.drg.clasificator.util.HeaderListReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResultSetToHeaderListConvertor
implements HeaderListReader {
    private final ResultSet resultSet;
    Map<String, Integer> headers;
    List<List<String>> columns;

    public ResultSetToHeaderListConvertor(ResultSet resultSet) {
        this.resultSet = resultSet;
        this.readResultSet();
    }

    private void readResultSet() {
        this.readHeadersFromResultSet();
        this.initColumns(this.headers.size());
        this.readRowsFromResultSet();
    }

    private void readHeadersFromResultSet() {
        try {
            ResultSetMetaData rsmd = this.resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.headers = new HashMap<String, Integer>();
            for (int i = 1; i <= columnCount; ++i) {
                String name = rsmd.getColumnName(i);
                this.headers.put(name, i - 1);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ResultSetToHeaderListConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readRowsFromResultSet() {
        try {
            ResultSetMetaData rsmd = this.resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (this.resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String colVal = this.resultSet.getString(i);
                    this.columns.get(i - 1).add(colVal);
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ResultSetToHeaderListConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initColumns(int columnsAmmount) {
        this.columns = new ArrayList<List<String>>();
        for (int i = 0; i < columnsAmmount; ++i) {
            this.columns.add(new ArrayList());
        }
    }

    @Override
    public Map<String, Integer> getHeadersWithIndexes() {
        return this.headers;
    }

    @Override
    public List<List<String>> getColumnLists() {
        return this.columns;
    }

    @Override
    public int getNumberOfLines() {
        return this.columns.get(0).size();
    }
}

