/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.setting;

import cz.drg.clasificator.setting.program.ACTIONSTYPE;
import cz.drg.clasificator.setting.program.Arguments;
import cz.drg.clasificator.setting.program.DatabaseDrivers;
import cz.drg.clasificator.setting.program.IOclass;
import cz.drg.clasificator.setting.program.Program;
import java.util.ArrayList;
import java.util.List;

public class ProgramSettings {
    private final Program base;

    public ProgramSettings(Program base) {
        this.base = base;
    }

    public List<Arguments.Argument> getArguments() {
        return this.base.getArguments().getArgument();
    }

    public IOclass getIOclass(String arg, String type) {
        List<IOclass> supportedIO = this.base.getIOclasses().getIOclass();
        for (IOclass iOclas : supportedIO) {
            if (!iOclas.getForArg().equalsIgnoreCase(arg) || !iOclas.getForType().equalsIgnoreCase(type)) continue;
            return iOclas;
        }
        return null;
    }

    public String getDefaultPmmlPath() {
        return this.base.getDefaultPmmlInput();
    }

    public String getDefaultInputPath() {
        return this.base.getDefaultInput();
    }

    public String getDefaultOutputPath() {
        return this.base.getDefaultOutput();
    }

    public String getDefaultCharset() {
        return this.base.getDefaultCharset();
    }

    public String getDefaultDelimiter() {
        return this.base.getDefaultDelimiter();
    }

    public int getEvaluationBatchSize() {
        return Integer.parseInt(this.base.getEvaluationBatchSize());
    }

    public List<String> getDatabaseDrivers() {
        DatabaseDrivers databaseDrivers = this.base.getDatabaseDrivers();
        if (databaseDrivers == null) {
            return new ArrayList<String>();
        }
        return this.base.getDatabaseDrivers().getDriverClass();
    }

    public boolean isSupportedType(String type) {
        for (String supportedVal : this.base.getIOtypes().getIOtype()) {
            if (!supportedVal.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedArgument(String argument) {
        for (Arguments.Argument supportedVal : this.base.getArguments().getArgument()) {
            if (!supportedVal.getValue().equalsIgnoreCase(argument)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedAction(String action) {
        for (ACTIONSTYPE supportedVal : this.base.getActions().getAction()) {
            if (!supportedVal.value().equalsIgnoreCase(action)) continue;
            return true;
        }
        return false;
    }
}

