/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.readers;

import cz.drg.clasificator.args.argevaluation.ConfigurableIOClass;
import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.readers.CsvReader;
import cz.drg.clasificator.readers.InputReader;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.setting.program.IOclass;
import cz.drg.clasificator.util.FilesCache;
import cz.drg.clasificator.util.HeaderList;
import cz.drg.clasificator.util.OutputHelper;
import cz.drg.clasificator.util.ResultSetToHeaderListConvertor;
import cz.drg.clasificator.writers.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class DBReader
implements InputReader,
ConfigurableIOClass {
    private static final String TEMP_FILE_NAME = "./log/DRGtemp%d.csv";
    private boolean isInitialized = false;
    private IOclass ioClass;
    private ZipFile pmmlInput;
    private Connection connection;
    private File tempCsv;
    private CsvReader tempCsvReader;
    private final String SELECT_ALL_QUERY = "SELECT * FROM %s";
    private final String SELECT_BY_ID_QUERY = "SELECT * FROM %s WHERE id_pripadu LIKE '%s' OR CAST(run_id AS VARCHAR(50)) LIKE '%s'";

    public DBReader() {
        try {
            this.pmmlInput = new ZipFile(Settings.getProgramSettings().getDefaultPmmlPath());
        }
        catch (IOException ex) {
            OutputHelper.dualLog("Error loading default PMML zip file: '" + Settings.getProgramSettings().getDefaultPmmlPath() + "'");
            System.exit(-1);
        }
    }

    private String getSelectByCaseIdOrRunIdQuery(String id) {
        return String.format("SELECT * FROM %s WHERE id_pripadu LIKE '%s' OR CAST(run_id AS VARCHAR(50)) LIKE '%s'", this.ioClass.getDatabaseTargetTable(), id, id);
    }

    private String getSelectAllQuery() {
        return String.format("SELECT * FROM %s", this.ioClass.getDatabaseTargetTable());
    }

    @Override
    public void initialize() {
        this.init(this.getSelectAllQuery());
    }

    public void initialize(String id) {
        this.init(this.getSelectByCaseIdOrRunIdQuery(id));
    }

    private void init(String query) {
        this.close();
        if (!this.isConnected()) {
            this.connection = this.createNewConnection();
        }
        try {
            PreparedStatement prepareStatement = this.connection.prepareStatement(query);
            ResultSet dbInput = prepareStatement.executeQuery();
            String defaultCharset = Settings.getProgramSettings().getDefaultCharset();
            this.tempCsv = this.createTempCsv();
            CsvWriter writer = new CsvWriter(this.tempCsv, "\t", defaultCharset);
            this.writeRowsFromResultSet(dbInput, writer);
            dbInput.close();
            prepareStatement.close();
        }
        catch (SQLException ex) {
            OutputHelper.dualLog(ex.getMessage());
            throw new ShutdownException("Reading from database failed.");
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(DBReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tempCsvReader = new CsvReader(this.tempCsv);
        this.isInitialized = true;
    }

    @Override
    public ZipFile readPmmlInput() {
        return this.pmmlInput;
    }

    @Override
    public HeaderList readNextEntryBatch() {
        if (!this.isInitialized) {
            this.initialize();
        }
        if (this.tempCsvReader.hasNextEntryBatch()) {
            return this.tempCsvReader.readNextEntryBatch();
        }
        throw new ShutdownException("Database reader has no aditional entries!");
    }

    private File createTempCsv() {
        File tempFile = null;
        try {
            String filePath = String.format(TEMP_FILE_NAME, System.currentTimeMillis());
            OutputHelper.errLog("Creating temporary csv file '" + filePath + "'.");
            tempFile = new File(filePath);
            tempFile.createNewFile();
            FilesCache.addCreatedFile(tempFile.getPath());
            OutputHelper.errLog("Temporary file created at " + tempFile.getPath() + "'.");
        }
        catch (IOException ex) {
            OutputHelper.dualLog(ex.getMessage());
            throw new ShutdownException("Cant create temp file for database results.");
        }
        return tempFile;
    }

    private Connection createNewConnection() {
        String databaseUrl = this.getTargetDatabaseUrl();
        OutputHelper.errLog("Creating new connection to database '" + databaseUrl + "' for reading.");
        String username = this.ioClass.getDatabaseUser();
        String password = this.ioClass.getDatabasePassword();
        if (username == null || password == null) {
            Scanner scan = new Scanner(System.in);
            OutputHelper.dualLog("Enter username:");
            username = scan.nextLine();
            OutputHelper.dualLog("Enter password:");
            password = scan.nextLine();
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(databaseUrl, username, password);
        }
        catch (SQLException ex) {
            OutputHelper.dualLog(ex.getMessage());
            throw new ShutdownException(String.format("Connection to database at '%s' could not be established.", databaseUrl));
        }
        return connection;
    }

    private List<String> readHeadersFromResultSet(ResultSet resultSet) {
        ArrayList<String> headerList = null;
        try {
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            headerList = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                String name = rsmd.getColumnName(i);
                headerList.add(name);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ResultSetToHeaderListConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return headerList;
    }

    private void writeRowsFromResultSet(ResultSet resultSet, CsvWriter writer) {
        try {
            List<String> headersFromResultSet = this.readHeadersFromResultSet(resultSet);
            String headerRow = this.listToString(headersFromResultSet);
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int batchSize = Settings.getProgramSettings().getEvaluationBatchSize();
            ArrayList<String> rowColumns = new ArrayList<String>();
            ArrayList<String> rows = new ArrayList<String>();
            rows.add(headerRow);
            long counter = 1L;
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnName(i);
                    String colVal = resultSet.getString(i);
                    if (colVal == null) {
                        colVal = "";
                    } else if (columnName.equalsIgnoreCase("datum_pri") || columnName.equalsIgnoreCase("datum_pro")) {
                        colVal = colVal.replaceAll("-", "");
                        colVal = colVal.substring(0, 8);
                    }
                    rowColumns.add(colVal);
                }
                rows.add(this.listToString(rowColumns));
                rowColumns.clear();
                if (counter % (long)batchSize == 0L) {
                    writer.writeOutput(rows);
                    rows.clear();
                    rows.add(headerRow);
                }
                ++counter;
            }
            writer.writeOutput(rows);
            rows.clear();
        }
        catch (SQLException ex) {
            Logger.getLogger(ResultSetToHeaderListConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String listToString(List<String> columns) {
        String result = "";
        for (int i = 0; i < columns.size(); ++i) {
            String col = columns.get(i);
            result = result + col;
            if (i == columns.size() - 1) continue;
            result = result + "\t";
        }
        return result;
    }

    @Override
    public boolean hasNextEntryBatch() {
        return this.tempCsvReader.hasNextEntryBatch();
    }

    @Override
    public void setIoClass(IOclass config) {
        this.ioClass = config;
    }

    private String getTargetDatabaseUrl() {
        return this.ioClass.getDatabaseConnection();
    }

    private boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBReader.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public void close() {
        if (this.tempCsv == null) {
            return;
        }
        try {
            this.tempCsvReader.close();
            Files.deleteIfExists(this.tempCsv.toPath());
            FilesCache.freeRemovedFile(this.tempCsv.getPath());
        }
        catch (IOException ex) {
            Logger.getLogger(DBReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

