/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.args.argevaluation;

import cz.drg.clasificator.args.ProgramExecutor;
import cz.drg.clasificator.args.argevaluation.ConfigurableIOClass;
import cz.drg.clasificator.args.argevaluation.Evaluator;
import cz.drg.clasificator.readers.InputReader;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.setting.program.ACTIONSTYPE;
import cz.drg.clasificator.setting.program.Arguments;
import cz.drg.clasificator.setting.program.IOclass;
import cz.drg.clasificator.writers.OutputWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class ArgEvaluator
implements Evaluator {
    public static final String HELP_ARG = "help";
    public static final String CONFIG_FILE_ARG = "configFile";
    public static final String DATABASE_ARG = "database";
    protected String argument;
    private List<String> parameters;

    public ArgEvaluator(String argument) {
        this.argument = argument;
        this.parameters = new ArrayList<String>();
    }

    private void registerDatabaseDrivers() {
        try {
            List<String> databaseDrivers = Settings.getProgramSettings().getDatabaseDrivers();
            for (String databaseDriver : databaseDrivers) {
                Class.forName(databaseDriver);
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Failed to load database driver.");
            System.err.println(ex.getMessage());
            System.exit(500);
        }
    }

    @Override
    public void evaluate(ProgramExecutor visitor) {
        Object object;
        Class<?> forName;
        if (this.argument.equalsIgnoreCase(HELP_ARG)) {
            visitor.stopExecution(this.getHelpMsg());
            return;
        }
        if (this.argument.equalsIgnoreCase(CONFIG_FILE_ARG)) {
            Settings.loadSettings(this.parameters.get(0));
            return;
        }
        if (this.parameters.isEmpty()) {
            visitor.stopExecution("If a argument is used, there need to be at least 'iotype' parameter! Use -help argument for more information.");
            return;
        }
        String datatype = this.parameters.get(0);
        IOclass iOclass = Settings.getProgramSettings().getIOclass(this.argument, datatype);
        if (iOclass == null) {
            visitor.stopExecution(String.format("No class for argument '%s' and type '%s' was found!", this.argument, datatype));
            return;
        }
        if (datatype.equalsIgnoreCase(DATABASE_ARG)) {
            this.registerDatabaseDrivers();
        }
        String classname = iOclass.getClassname();
        try {
            forName = Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            visitor.stopExecution("Configured IO class '%s' was not found!");
            return;
        }
        Class[] parameterTypes = new Class[this.parameters.size() - 1];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = String.class;
        }
        List<Object> subList = this.parameters.size() - 1 > 0 ? this.parameters.subList(1, this.parameters.size()) : new ArrayList();
        try {
            object = forName.getConstructor(parameterTypes).newInstance(subList.toArray());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            visitor.stopExecution("Used reader/writer does not support that many parameters. See -help for more information.");
            return;
        }
        if (object instanceof ConfigurableIOClass) {
            ((ConfigurableIOClass)object).setIoClass(iOclass);
        }
        ACTIONSTYPE forAction = iOclass.getForAction();
        this.setActionForVisitor(visitor, forAction, object);
    }

    private void setActionForVisitor(ProgramExecutor visitor, ACTIONSTYPE forAction, Object object) {
        switch (forAction) {
            case READ: {
                visitor.setReader((InputReader)object);
                break;
            }
            case WRITE: {
                visitor.setWriter((OutputWriter)object);
                break;
            }
            default: {
                visitor.stopExecution(String.format("No action with name '%s' is supported!", new Object[]{forAction}));
            }
        }
    }

    private String getHelpMsg() {
        String supportedArgs = "Supported program arguments:\n";
        for (Arguments.Argument argument : Settings.getProgramSettings().getArguments()) {
            supportedArgs = supportedArgs + String.format("-%-10s%s\n", argument.getValue(), argument.getDescription());
        }
        return supportedArgs;
    }

    @Override
    public void addParameter(String param) {
        this.parameters.add(param);
    }

    @Override
    public Evaluator clearParameters() {
        this.parameters.clear();
        return this;
    }

    public String toString() {
        String result = "-" + this.argument;
        for (String parameter : this.parameters) {
            result = result + " " + parameter;
        }
        return result;
    }
}

