/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.args;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import cz.drg.clasificator.CZDRGClasificatorService;
import cz.drg.clasificator.args.ProgramExecutor;
import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.readers.DBReader;
import cz.drg.clasificator.readers.InputReader;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.util.OutputHelper;
import cz.drg.clasificator.writers.DBWriter;
import cz.drg.clasificator.writers.OutputWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CZDRGServiceExecutor
implements ProgramExecutor,
Runnable {
    private static final int DEFAULT_PORT = 8888;
    private int serverPort = 8888;
    public static final String DASHES = new String(new char[50]).replace("\u0000", "-");

    public CZDRGServiceExecutor() {
        Settings.loadSettings();
        this.registerDatabaseDrivers();
    }

    private void registerDatabaseDrivers() {
        try {
            List<String> databaseDrivers = Settings.getProgramSettings().getDatabaseDrivers();
            for (String databaseDriver : databaseDrivers) {
                Class.forName(databaseDriver);
            }
        }
        catch (ClassNotFoundException ex) {
            OutputHelper.dualLog("Failed to load database driver.");
            OutputHelper.dualLog(ex.getMessage());
            System.exit(500);
        }
    }

    @Override
    public void stopExecution(String message) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execute(String[] args) {
        if (args.length > 1) {
            try {
                this.serverPort = Integer.parseInt(args[1]);
                OutputHelper.dualLog("Received port: " + this.serverPort);
            }
            catch (NumberFormatException ex) {
                OutputHelper.dualLog("Invalid port: '" + args[1] + "', falling back to default port " + this.serverPort);
            }
        }
        OutputHelper.dualLog("Starting http handler on port " + this.serverPort);
        new Thread(this).start();
    }

    @Override
    public void setWriter(OutputWriter writer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setReader(InputReader reader) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void run() {
        try {
            OutputHelper.dualLog("Creating new http service on port " + this.serverPort + ".");
            HttpServer server = HttpServer.create(new InetSocketAddress(this.serverPort), 0);
            server.createContext("/", new PostRequestHandler());
            server.setExecutor(null);
            server.start();
            OutputHelper.dualLog("Http service started on port " + this.serverPort + ".");
        }
        catch (BindException ex) {
            OutputHelper.dualLog("Port " + this.serverPort + " is already in use. Closing http server instance.");
        }
        catch (IOException ex) {
            Logger.getLogger(CZDRGServiceExecutor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static class PostRequestHandler
    implements HttpHandler {
        private final DBReader dbReader = new DBReader();
        private final DBWriter dbWriter;
        private final CZDRGClasificatorService clasificator;

        public PostRequestHandler() {
            this.dbReader.setIoClass(Settings.getProgramSettings().getIOclass("input", "database"));
            this.dbWriter = new DBWriter();
            this.dbWriter.setIoClass(Settings.getProgramSettings().getIOclass("output", "database"));
            this.dbWriter.setIsService(true);
            this.clasificator = new CZDRGClasificatorService();
            this.clasificator.processPMML(this.dbReader);
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            OutputHelper.dualLog(DASHES);
            OutputHelper.dualLog("Received " + t.getRequestMethod() + " reguest on " + t.getLocalAddress() + t.getRequestURI());
            for (Map.Entry<String, List<String>> entry : t.getRequestHeaders().entrySet()) {
                OutputHelper.dualLog("Request: " + entry.getKey() + " : " + entry.getValue());
            }
            OutputHelper.dualLog("Request:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(t.getRequestBody()));
            String caseId = reader.readLine();
            OutputHelper.dualLog("Request: " + caseId);
            OutputHelper.dualLog(DASHES);
            OutputHelper.dualLog("Processing id '" + caseId + "'");
            reader.close();
            try {
                this.dbReader.initialize(caseId);
                this.clasificator.setCurentCaseId(caseId);
                this.clasificator.startEvaluation(this.dbReader, this.dbWriter);
                t.sendResponseHeaders(200, -1L);
            }
            catch (ShutdownException ex) {
                OutputHelper.dualLog("Evaluation failed: " + ex.getMessage());
                t.sendResponseHeaders(404, -1L);
            }
        }
    }
}

