/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator;

import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.readers.InputReader;
import cz.drg.clasificator.util.HeaderList;
import cz.drg.clasificator.util.OutputHelper;
import cz.drg.clasificator.util.UnmarshallOptimized;
import cz.drg.clasificator.writers.OutputWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipFile;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.ValueCheckException;
import org.jpmml.evaluator.visitors.DefaultModelEvaluatorBattery;
import org.jpmml.model.InvalidElementException;

public class CZDRGClasificator {
    private PMML pmml;
    private Evaluator evaluator;
    private Map<String, Object> errorCodeMapping = new HashMap<String, Object>();

    public CZDRGClasificator() {
        this.initErrorMapping();
    }

    public void processPMML(InputReader reader) {
        long now;
        block10: {
            now = System.currentTimeMillis();
            try {
                ZipFile pmmlZipFile = reader.readPmmlInput();
                File pmmlByteFile = new File(pmmlZipFile.getName().split("\\.")[0] + ".model");
                if (!pmmlByteFile.exists()) {
                    OutputHelper.dualLog("Missing PMML model file detected. Generating new PMML model.");
                    this.unmarshalAndCreatePmmlByteModel(pmmlZipFile, pmmlByteFile);
                    this.updatePmmlModelByteFileLastModifiedTime(pmmlZipFile, pmmlByteFile);
                    break block10;
                }
                if (!this.getLastModifiedTime(pmmlZipFile).equals(this.getLastModifiedTime(pmmlByteFile))) {
                    OutputHelper.dualLog("Changed PMML zip file detected. Generating new PMML model.");
                    pmmlByteFile.delete();
                    this.unmarshalAndCreatePmmlByteModel(pmmlZipFile, pmmlByteFile);
                    this.updatePmmlModelByteFileLastModifiedTime(pmmlZipFile, pmmlByteFile);
                    break block10;
                }
                try (ObjectInputStream ois2 = new ObjectInputStream(new InflaterInputStream(new FileInputStream(pmmlByteFile)));){
                    this.pmml = (PMML)ois2.readObject();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CZDRGClasificator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(CZDRGClasificator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println("Unmarshaled PMML after " + (System.currentTimeMillis() - now) + "ms.");
        ModelEvaluatorBuilder evaluatorBuilder = new ModelEvaluatorBuilder(this.pmml).setModelEvaluatorFactory(ModelEvaluatorFactory.newInstance());
        this.evaluator = evaluatorBuilder.build();
        this.evaluator.verify();
    }

    private void unmarshalAndCreatePmmlByteModel(ZipFile pmmlZipFile, File pmmlByteFile) throws FileNotFoundException, IOException {
        this.pmml = new UnmarshallOptimized().unmarshal(pmmlZipFile);
        this.optimizePmml(this.pmml);
        try (ObjectOutputStream os = new ObjectOutputStream(new DeflaterOutputStream(new FileOutputStream(pmmlByteFile)));){
            os.writeObject(this.pmml);
        }
    }

    public void startEvaluation(InputReader reader, OutputWriter writer) {
        long evaluationStartTime = System.currentTimeMillis();
        if (this.pmml == null || this.evaluator == null) {
            this.processPMML(reader);
        }
        writer.clear();
        long readLines = 0L;
        long writtenLines = 0L;
        long errorLines = 0L;
        long noClasificationLines = 0L;
        while (reader.hasNextEntryBatch()) {
            HeaderList inputList = reader.readNextEntryBatch();
            List<Map<String, ?>> outputRecords = this.evaluateInput(this.evaluator, inputList);
            List<List<String>> lines = this.transformOutput(this.evaluator, outputRecords);
            writer.writeOutput(inputList, lines);
            writtenLines += (long)(lines.size() - 1);
            OutputHelper.dualLog("Batch of size " + inputList.numOfLines());
            OutputHelper.dualLog("Total of " + (readLines += (long)inputList.numOfLines()) + " entries.");
            for (Map<String, ?> outputRecord : outputRecords) {
                Object errorCode = outputRecord.get("CHYBA");
                Object clasification = outputRecord.get("DRG");
                if (outputRecord.isEmpty() || !errorCode.equals(0)) {
                    ++errorLines;
                }
                if (outputRecord.isEmpty() || !clasification.equals("missing")) continue;
                ++noClasificationLines;
            }
        }
        writer.close();
        reader.close();
        this.logResult(evaluationStartTime, readLines, writtenLines, errorLines, noClasificationLines);
        if (readLines != writtenLines) {
            throw new ShutdownException("Could not set default reader/writer.");
        }
    }

    protected void logResult(long evaluationStartTime, long readLines, long writtenLines, long errorLines, long noClasificationLines) {
        double timeElapsedSec = (double)(System.currentTimeMillis() - evaluationStartTime) / 1000.0;
        OutputHelper.separatorLog();
        OutputHelper.dualLog(String.format("%-16s%8d", "Input entries", readLines).replaceAll("\\s(?=\\s+)", "."));
        OutputHelper.dualLog(String.format("%-16s%8d", "Output entries", writtenLines).replaceAll("\\s(?=\\s+)", "."));
        OutputHelper.dualLog(String.format("%-16s%8d", "Valid entries", writtenLines - errorLines).replaceAll("\\s(?=\\s+)", "."));
        OutputHelper.dualLog(String.format("%-16s%8d", "Error entries", errorLines).replaceAll("\\s(?=\\s+)", "."));
        OutputHelper.dualLog(String.format("%-16s%8d", "No clasification", noClasificationLines).replaceAll("\\s(?=\\s+)", "."));
        OutputHelper.separatorLog();
        OutputHelper.dualLog(String.format("Evaluated after %.3f sec", timeElapsedSec));
        OutputHelper.separatorLog();
    }

    private List<Map<String, ?>> evaluateInput(Evaluator evaluator2, HeaderList inputList) {
        ArrayList outputRecords = new ArrayList();
        this.fillWithNulls(inputList.numOfLines(), outputRecords);
        List<Map<String, String>> rows = inputList.getRows();
        IntStream.range(0, rows.size()).parallel().forEach(index -> {
            try {
                Map<String, ?> evaluated = this.prepareEagerlyAndEvaluate(evaluator2, (Map)rows.get(index));
                HashMap result = new HashMap();
                for (Map.Entry<String, ?> e : evaluated.entrySet()) {
                    result.put(e.getKey(), e.getValue());
                }
                outputRecords.set(index, result);
            }
            catch (EvaluationException ex) {
                OutputHelper.dualLog("Something went wrong during evaluation.");
                OutputHelper.dualLog(ex.getMessage());
                System.exit(-1);
            }
            catch (InvalidElementException ex) {
                OutputHelper.dualLog("Invalid element in model detected. Skipping entry triggering exception on index " + index + " of current batch.");
                OutputHelper.dualLog(ex.getMessage());
                HashMap result = new HashMap();
                outputRecords.set(index, result);
            }
        });
        return outputRecords;
    }

    private void initErrorMapping() {
        this.errorCodeMapping.put("LOS", 2);
        this.errorCodeMapping.put("VEKLET", 3);
        this.errorCodeMapping.put("VEKDEN", 3);
        this.errorCodeMapping.put("POHLAVI", 4);
        this.errorCodeMapping.put("UKONCENI", 5);
        this.errorCodeMapping.put("HMOTNOST", 6);
        this.errorCodeMapping.put("ODB_PRI", 7);
        this.errorCodeMapping.put("DG_HLAVNI", 8);
        this.errorCodeMapping.put("UPV", 9);
        this.errorCodeMapping.put("GEST_VEK", 10);
        this.errorCodeMapping.put("VERZE_P", 11);
        this.errorCodeMapping.put("OZ_DNY", 13);
        this.errorCodeMapping.put("RHB_DNY", 13);
        this.errorCodeMapping.put("PS_DNY", 13);
        this.errorCodeMapping.put("KRN_DNY", 13);
        this.errorCodeMapping.put("POP_DNY", 13);
        this.errorCodeMapping.put("DIA_DNY", 13);
        this.errorCodeMapping.put("HRU_DNY", 13);
        this.errorCodeMapping.put("BRI_DNY", 13);
        this.errorCodeMapping.put("ZLU_DNY", 13);
        this.errorCodeMapping.put("HRD_DNY", 13);
        this.errorCodeMapping.put("OKO_DNY", 13);
        this.errorCodeMapping.put("SRD_DNY", 13);
        this.errorCodeMapping.put("CEV_DNY", 13);
        this.errorCodeMapping.put("HDL_DNY", 13);
        this.errorCodeMapping.put("KP1", 14);
        this.errorCodeMapping.put("KP2", 14);
        this.errorCodeMapping.put("KP3", 14);
        this.errorCodeMapping.put("KP4", 14);
        this.errorCodeMapping.put("KP5", 14);
        this.errorCodeMapping.put("KP6", 14);
        this.errorCodeMapping.put("KP7", 14);
        this.errorCodeMapping.put("KP8", 14);
        this.errorCodeMapping.put("KP9", 14);
        this.errorCodeMapping.put("KP10", 14);
    }

    private Map<String, ?> prepareEagerlyAndEvaluate(Evaluator evaluator, Map<String, String> userArguments) {
        LinkedHashMap<String, FieldValue> pmmlArguments = new LinkedHashMap<String, FieldValue>();
        List<InputField> activeFields = evaluator.getActiveFields();
        for (InputField activeField : activeFields) {
            String userValue = userArguments.get(activeField.getFieldName());
            FieldValue pmmlValue = null;
            try {
                pmmlValue = activeField.prepare(userValue != null && !userValue.isEmpty() ? userValue : null);
            }
            catch (InvalidResultException | ValueCheckException ex) {
                OutputHelper.dualLog(ex.getMessage());
                String message = ex.getMessage();
                String errorFieldName = message.split("\"")[1];
                List<OutputField> outputFields = evaluator.getOutputFields();
                HashMap<String, Object> errorOutputRecord = new HashMap<String, Object>();
                for (OutputField outputField : outputFields) {
                    if (outputField.getFieldName().equalsIgnoreCase("CHYBA")) {
                        errorOutputRecord.put(outputField.getName(), this.errorCodeMapping.getOrDefault(errorFieldName, -1));
                        continue;
                    }
                    if (outputField.getFieldName().equalsIgnoreCase("verze_g")) {
                        errorOutputRecord.put(outputField.getName(), this.getClass().getPackage().getImplementationVersion());
                        continue;
                    }
                    if (outputField.getFieldName().equalsIgnoreCase("skore_zav")) {
                        errorOutputRecord.put(outputField.getName(), 0);
                        continue;
                    }
                    if (outputField.getFieldName().equalsIgnoreCase("DRG")) {
                        errorOutputRecord.put(outputField.getName(), "missing");
                        continue;
                    }
                    if (outputField.getFieldName().equalsIgnoreCase("DRG_KAT")) {
                        errorOutputRecord.put(outputField.getName(), "missing");
                        continue;
                    }
                    errorOutputRecord.put(outputField.getName(), "");
                }
                return errorOutputRecord;
            }
            pmmlArguments.put(activeField.getName(), pmmlValue);
        }
        return evaluator.evaluate(pmmlArguments);
    }

    private void optimizePmml(PMML pmml) {
        DefaultModelEvaluatorBattery dmeb = new DefaultModelEvaluatorBattery();
        dmeb.applyTo(pmml);
    }

    private List<List<String>> transformOutput(Evaluator evaluator, List<Map<String, ?>> outputRecords) {
        List<OutputField> outputFields = evaluator.getOutputFields();
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        ArrayList<String> headerLine = new ArrayList<String>();
        for (OutputField outputField : outputFields) {
            if (!outputField.isFinalResult()) continue;
            headerLine.add(outputField.getFieldName());
        }
        lines.add(headerLine);
        ArrayList<String> line = new ArrayList<String>();
        for (Map<String, ?> outputRecord : outputRecords) {
            for (OutputField outputField : outputFields) {
                if (!outputField.isFinalResult() || !outputRecord.containsKey(outputField.getFieldName())) continue;
                line.add(String.valueOf(outputRecord.get(outputField.getFieldName())));
            }
            lines.add(line);
            line = new ArrayList();
        }
        return lines;
    }

    private void updatePmmlModelByteFileLastModifiedTime(ZipFile pmmlZipFile, File pmmlByteFile) throws IOException {
        Files.setLastModifiedTime(pmmlByteFile.toPath(), this.getLastModifiedTime(pmmlZipFile));
    }

    private FileTime getLastModifiedTime(ZipFile file) throws IOException {
        return this.getLastModifiedTime(new File(file.getName()));
    }

    private FileTime getLastModifiedTime(File file) throws IOException {
        BasicFileAttributes pmmlByteFileAtt = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        return pmmlByteFileAtt.lastModifiedTime();
    }

    private void fillWithNulls(int numOfNulls, List<?> arr) {
        for (int i = 0; i < numOfNulls; ++i) {
            arr.add(null);
        }
    }
}

