/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.tableaction;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.talend.components.common.tableaction.DefaultSQLClearTableAction;
import org.talend.components.common.tableaction.DefaultSQLCreateTableAction;
import org.talend.components.common.tableaction.DefaultSQLTruncateTableAction;
import org.talend.components.common.tableaction.NoAction;
import org.talend.components.common.tableaction.TableAction;
import org.talend.components.common.tableaction.TableActionConfig;

public class TableActionManager {
    private static TableAction noAction = new NoAction();

    public static final List<String> buildQueries(TableAction.TableActionEnum action, String[] fullTableName, Schema schema, TableActionConfig config, Map<String, String> dbTypeMap) throws Exception {
        TableAction tableAction = TableActionManager.create(action, fullTableName, schema);
        tableAction.setConfig(config);
        tableAction.setDbTypeMap(dbTypeMap);
        return tableAction.getQueries();
    }

    public static final TableAction create(TableAction.TableActionEnum action, String[] fullTableName, Schema schema) {
        switch (action) {
            case CREATE: {
                return new DefaultSQLCreateTableAction(fullTableName, schema, false, false, false);
            }
            case DROP_CREATE: {
                return new DefaultSQLCreateTableAction(fullTableName, schema, false, true, false);
            }
            case DROP_IF_EXISTS_AND_CREATE: {
                return new DefaultSQLCreateTableAction(fullTableName, schema, false, true, true);
            }
            case CREATE_IF_NOT_EXISTS: {
                return new DefaultSQLCreateTableAction(fullTableName, schema, true, false, false);
            }
            case CLEAR: {
                return new DefaultSQLClearTableAction(fullTableName);
            }
            case TRUNCATE: {
                return new DefaultSQLTruncateTableAction(fullTableName);
            }
        }
        return noAction;
    }

    public static final void exec(Connection connection, TableAction.TableActionEnum action, String[] fullTableName, Schema schema) throws Exception {
        TableActionManager.exec(connection, action, fullTableName, schema, new TableActionConfig());
    }

    public static final void exec(Connection connection, TableAction.TableActionEnum action, String[] fullTableName, Schema schema, TableActionConfig config) throws Exception {
        TableActionManager.exec(connection, action, fullTableName, schema, config, new HashMap<String, String>());
    }

    public static void exec(Connection connection, TableAction.TableActionEnum action, String[] fullTableName, Schema schema, TableActionConfig config, Map<String, String> dbTypeMap) throws Exception {
        for (String q : TableActionManager.buildQueries(action, fullTableName, schema, config, dbTypeMap)) {
            connection.createStatement().execute(q);
        }
    }
}

