/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.tableaction;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.tableaction.TableAction;

public class DefaultSQLTruncateTableAction
extends TableAction {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSQLTruncateTableAction.class);
    private String[] fullTableName;

    public DefaultSQLTruncateTableAction(String[] fullTableName) {
        if (fullTableName == null || fullTableName.length < 1) {
            throw new InvalidParameterException("Table name can't null or empty");
        }
        this.fullTableName = fullTableName;
    }

    @Override
    public List<String> getQueries() throws Exception {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add(this.getTruncateTableQuery());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated SQL queries to truncate table:");
            for (String q : queries) {
                LOG.debug(q);
            }
        }
        return queries;
    }

    private String getTruncateTableQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getConfig().SQL_TRUNCATE_PREFIX);
        sb.append(this.getConfig().SQL_TRUNCATE);
        sb.append(" ");
        sb.append(this.buildFullTableName(this.fullTableName, this.getConfig().SQL_FULL_NAME_SEGMENT_SEP, true));
        sb.append(this.getConfig().SQL_TRUNCATE_SUFFIX);
        return sb.toString();
    }
}

