/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.tableaction;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.tableaction.TableAction;

public class DefaultSQLClearTableAction
extends TableAction {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSQLClearTableAction.class);
    private String[] fullTableName;

    public DefaultSQLClearTableAction(String[] fullTableName) {
        if (fullTableName == null || fullTableName.length < 1) {
            throw new InvalidParameterException("Table name can't null or empty");
        }
        this.fullTableName = fullTableName;
    }

    @Override
    public List<String> getQueries() throws Exception {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add(this.getClearTableQuery());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated SQL queries to clear table:");
            for (String q : queries) {
                LOG.debug(q);
            }
        }
        return queries;
    }

    private String getClearTableQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getConfig().SQL_DELETE_PREFIX);
        sb.append(this.getConfig().SQL_DELETE);
        sb.append(" ");
        sb.append(this.buildFullTableName(this.fullTableName, this.getConfig().SQL_FULL_NAME_SEGMENT_SEP, true));
        sb.append(this.getConfig().SQL_DELETE_SUFFIX);
        return sb.toString();
    }
}

