/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.runtime;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.talend.components.common.ProxyProperties;

public class ProxyPropertiesRuntimeHelper {
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPwd;
    private Proxy socketProxy;

    public ProxyPropertiesRuntimeHelper(ProxyProperties proxySetting) {
        if (((Boolean)proxySetting.useProxy.getValue()).booleanValue()) {
            this.proxyHost = proxySetting.host.getStringValue();
            this.proxyPort = proxySetting.port.getStringValue();
            this.proxyUser = proxySetting.userPassword.userId.getStringValue();
            this.proxyPwd = proxySetting.userPassword.password.getStringValue();
            InetSocketAddress addr = new InetSocketAddress(this.proxyHost, Integer.parseInt(this.proxyPort));
            this.socketProxy = new Proxy(Proxy.Type.SOCKS, addr);
        } else if (System.getProperty("https.proxyHost") != null) {
            this.proxyHost = System.getProperty("https.proxyHost");
            this.proxyPort = System.getProperty("https.proxyPort");
            this.proxyUser = System.getProperty("https.proxyUser");
            this.proxyPwd = System.getProperty("https.proxyPassword");
        } else if (System.getProperty("http.proxyHost") != null) {
            this.proxyHost = System.getProperty("http.proxyHost");
            this.proxyPort = System.getProperty("http.proxyPort");
            this.proxyUser = System.getProperty("http.proxyUser");
            this.proxyPwd = System.getProperty("http.proxyPassword");
        } else if (System.getProperty("socksProxyHost") != null) {
            this.proxyHost = System.getProperty("socksProxyHost");
            this.proxyPort = System.getProperty("socksProxyPort");
            this.proxyUser = System.getProperty("java.net.socks.username");
            this.proxyPwd = System.getProperty("java.net.socks.password");
            InetSocketAddress addr = new InetSocketAddress(this.proxyHost, Integer.parseInt(this.proxyPort));
            this.socketProxy = new Proxy(Proxy.Type.SOCKS, addr);
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPwd() {
        return this.proxyPwd;
    }

    public Proxy getSocketProxy() {
        return this.socketProxy;
    }
}

