/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.runtime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.AvroRegistry;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.converter.AvroConverter;
import org.talend.daikon.java8.SerializableFunction;

public class GenericAvroRegistry
extends AvroRegistry {
    private static final GenericAvroRegistry sInstance = new GenericAvroRegistry();

    private GenericAvroRegistry() {
        this.registerSchemaInferrer(IndexedRecord.class, (SerializableFunction)new SerializableFunction<IndexedRecord, Schema>(){
            private static final long serialVersionUID = 1L;

            public Schema apply(IndexedRecord t) {
                return GenericAvroRegistry.this.inferSchemaRecord(t);
            }
        });
        this.registerSchemaInferrer(Schema.Field.class, (SerializableFunction)new SerializableFunction<Schema.Field, Schema>(){
            private static final long serialVersionUID = 1L;

            public Schema apply(Schema.Field t) {
                return GenericAvroRegistry.this.inferSchemaField(t);
            }
        });
    }

    public static GenericAvroRegistry get() {
        return sInstance;
    }

    private Schema inferSchemaRecord(IndexedRecord in) {
        SchemaBuilder.FieldAssembler builder = SchemaBuilder.builder().record(in.getSchema().getName()).fields();
        for (Schema.Field field : in.getSchema().getFields()) {
            Schema fieldSchema = this.inferSchema(field);
            Object fieldDefault = field.defaultVal();
            if (null == fieldDefault) {
                builder = builder.name(field.name()).type(fieldSchema).noDefault();
                continue;
            }
            builder = builder.name(field.name()).type(fieldSchema).withDefault(fieldDefault);
        }
        return (Schema)builder.endRecord();
    }

    private Schema inferSchemaField(Schema.Field field) {
        return field.schema();
    }

    public AvroConverter<String, ?> convertToString(Schema.Field f) {
        Schema fieldSchema = AvroUtils.unwrapIfNullable((Schema)f.schema());
        switch (fieldSchema.getType()) {
            case LONG: {
                String pattern = f.getProp("talend.field.pattern");
                if (pattern != null && !pattern.isEmpty()) {
                    fieldSchema.addProp("talend.field.pattern", pattern);
                    return new DateToStringConvert(fieldSchema);
                }
                return super.getConverter(String.class);
            }
        }
        return super.getConverter(String.class);
    }

    public static class DateToStringConvert
    extends AsStringConverter<Date> {
        private final SimpleDateFormat format;

        DateToStringConvert(Schema schema) {
            super(schema);
            String pattern = schema.getProp("talend.field.pattern");
            this.format = new SimpleDateFormat(pattern);
        }

        public Date convertToAvro(String value) {
            try {
                return value == null ? null : this.format.parse(value);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public String convertToDatum(Date value) {
            return value == null ? null : this.format.format(value);
        }
    }

    public static abstract class AsStringConverter<T>
    implements AvroConverter<String, T> {
        private final Schema schema;

        AsStringConverter(Schema schema) {
            this.schema = schema;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public Class<String> getDatumClass() {
            return String.class;
        }

        public String convertToDatum(T value) {
            return value == null ? null : String.valueOf(value);
        }
    }
}

