/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.runtime;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.talend.components.common.runtime.FastDateParser;

public class FormatterUtils {
    public static final String dateDefaultPattern = "dd-MM-yyyy";

    public static String formatDate(Date date, String pattern) {
        if (date != null) {
            DateFormat format = FastDateParser.getInstance(pattern == null ? dateDefaultPattern : pattern);
            format.setTimeZone(TimeZone.getDefault());
            return format.format(date);
        }
        return null;
    }

    public static String formatNumber(String s, Character thousandsSeparator, Character decimalSeparator) {
        if (s == null) {
            return null;
        }
        String result = s;
        int decimalIndex = s.indexOf(".");
        if (decimalIndex == -1) {
            if (thousandsSeparator != null) {
                return FormatterUtils.formatNumber(result, thousandsSeparator.charValue());
            }
            return result;
        }
        result = thousandsSeparator != null ? FormatterUtils.formatNumber(s.substring(0, decimalIndex), thousandsSeparator.charValue()) : s.substring(0, decimalIndex);
        result = decimalSeparator != null ? result + s.substring(decimalIndex).replace('.', decimalSeparator.charValue()) : result + s.substring(decimalIndex);
        return result;
    }

    private static String formatNumber(String s, char thousandsSeparator) {
        StringBuilder sb = new StringBuilder(s);
        int index = sb.length();
        index -= 3;
        while (index > 0 && sb.charAt(index - 1) != '-') {
            sb.insert(index, thousandsSeparator);
            index -= 3;
        }
        return sb.toString();
    }
}

