/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.exception.ComponentException;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.error.DefaultErrorCode;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.i18n.GlobalI18N;
import org.talend.daikon.i18n.I18nMessages;

public class DynamicSchemaUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSchemaUtils.class);
    private static final I18nMessages I18N_MESSAGES = GlobalI18N.getI18nMessageProvider().getI18nMessages(DynamicSchemaUtils.class);

    private DynamicSchemaUtils() {
    }

    public static List<Schema.Field> getCommonFieldsForDynamicSchema(Schema remoteSchema, Schema inputSchema) {
        if (remoteSchema == null || remoteSchema.getFields().isEmpty()) {
            DynamicSchemaUtils.throwSchemaValidationException("error.message.remoteSchemaNotSet");
        }
        if (inputSchema == null || inputSchema.getFields().isEmpty()) {
            DynamicSchemaUtils.throwSchemaValidationException("error.message.inputSchemaNotSet");
        }
        ArrayList<Schema.Field> commonFields = new ArrayList<Schema.Field>(remoteSchema.getFields().size());
        ArrayList inputFields = new ArrayList(inputSchema.getFields());
        boolean completelyDifferent = true;
        for (Schema.Field snowflakeRuntimeField : remoteSchema.getFields()) {
            boolean added = false;
            Iterator iterator = inputFields.iterator();
            while (iterator.hasNext()) {
                Schema.Field incomingField = (Schema.Field)iterator.next();
                if (!incomingField.name().equalsIgnoreCase(snowflakeRuntimeField.name())) continue;
                commonFields.add(incomingField);
                iterator.remove();
                added = true;
                completelyDifferent = false;
                break;
            }
            if (added) continue;
            commonFields.add(null);
        }
        if (completelyDifferent) {
            DynamicSchemaUtils.throwSchemaValidationException("error.message.differentSchema");
        }
        if (inputFields.size() != 0) {
            Object[] names = new String[inputFields.size()];
            for (int i = 0; i < inputFields.size(); ++i) {
                names[i] = ((Schema.Field)inputFields.get(i)).name();
            }
            LOGGER.warn(I18N_MESSAGES.getMessage("warning.message.unusedColumns", new Object[]{Arrays.toString(names)}));
        }
        return commonFields;
    }

    private static void throwSchemaValidationException(String messagePropertyName) {
        throw new ComponentException((ErrorCode)new DefaultErrorCode(400, new String[]{"errorMessage"}), new ExceptionContext.ExceptionContextBuilder().put("errorMessage", (Object)I18N_MESSAGES.getMessage(messagePropertyName, new Object[0])).build());
    }
}

