/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.format;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.NamedThing;
import org.talend.daikon.definition.Definition;
import org.talend.daikon.definition.service.DefinitionRegistryService;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public abstract class FormatPropertiesProvider<V extends Properties>
extends PropertiesImpl {
    private static final long serialVersionUID = 7293969314564405598L;
    private static final String FORMAT_PROPERTIES_NAME = "formatProperties";
    @Inject
    public transient DefinitionRegistryService definitionRegistry;
    public final Property<String> format = PropertyFactory.newString((String)"format");
    public V formatProperties;
    private final Class<? extends Definition<V>> definitionClass;
    private transient String previousFormatValue = "";
    private transient Map<String, ? extends Definition<V>> allFormatDefs = new HashMap<String, Definition<V>>();
    private transient Map<String, V> referenceMemento = new HashMap<String, V>();

    public FormatPropertiesProvider(String name, Class<? extends Definition<V>> definitionClass) {
        super(name);
        this.definitionClass = definitionClass;
    }

    public void setupProperties() {
        super.setupProperties();
        this.initFormatProperty();
    }

    public void setupLayout() {
        super.setupLayout();
        Form mainForm = new Form((Properties)this, "Main");
        mainForm.addRow(Widget.widget(this.format).setWidgetType("widget.type.enumeration"));
        this.refreshLayout(mainForm);
    }

    public void afterFormat() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        if (form.getName().equals("Main")) {
            this.createFormatValues();
            Widget w = form.getWidget(FORMAT_PROPERTIES_NAME);
            if (!this.allFormatDefs.isEmpty() && w != null) {
                this.updateProperties();
                form.replaceRow(FORMAT_PROPERTIES_NAME, (NamedThing)this.formatProperties.getForm("Main"));
            } else if (!this.allFormatDefs.isEmpty() && w == null) {
                this.updateProperties();
                form.addRow((NamedThing)this.formatProperties.getForm("Main"));
            }
            form.getWidget(this.format.getName()).setReadonly(this.allFormatDefs.isEmpty());
        }
    }

    protected Class<? extends Definition<V>> getDefinitionClass() {
        return this.definitionClass;
    }

    private void initFormatProperty() {
        this.createFormatValues();
        this.updateProperties();
    }

    private void createFormatValues() {
        this.allFormatDefs = this.getPossibleFormatValues();
        Object[] defsNames = this.allFormatDefs.keySet().toArray();
        if (defsNames.length > 0) {
            this.format.setPossibleValues(defsNames);
            if (this.format.getValue() == null || ((String)this.format.getValue()).isEmpty()) {
                this.format.setStoredValue(defsNames[0]);
            }
        }
    }

    private void updateProperties() {
        String selectedFileFormatDefinitionStr = (String)this.format.getValue();
        if (!StringUtils.isEmpty((CharSequence)selectedFileFormatDefinitionStr) && !StringUtils.equals((CharSequence)this.previousFormatValue, (CharSequence)selectedFileFormatDefinitionStr)) {
            Properties props = (Properties)this.referenceMemento.get(selectedFileFormatDefinitionStr);
            if (props == null) {
                Definition fileFormatDefinition = (Definition)this.getDefinitionRegistry().getDefinitionsMapByType(this.getDefinitionClass()).get(selectedFileFormatDefinitionStr);
                props = this.getDefinitionRegistry().createProperties(fileFormatDefinition, FORMAT_PROPERTIES_NAME);
                this.referenceMemento.put(selectedFileFormatDefinitionStr, props);
            }
            this.formatProperties = props;
        } else if (!StringUtils.isEmpty((CharSequence)selectedFileFormatDefinitionStr) && StringUtils.equals((CharSequence)this.previousFormatValue, (CharSequence)selectedFileFormatDefinitionStr)) {
            this.referenceMemento.put(selectedFileFormatDefinitionStr, this.formatProperties);
        }
        this.previousFormatValue = selectedFileFormatDefinitionStr;
    }

    protected DefinitionRegistryService getDefinitionRegistry() {
        return this.definitionRegistry;
    }

    protected Map<String, ? extends Definition<V>> getPossibleFormatValues() {
        DefinitionRegistryService registry = this.getDefinitionRegistry();
        if (registry == null) {
            return Collections.emptyMap();
        }
        return registry.getDefinitionsMapByType(this.getDefinitionClass());
    }

    public V getFormatProperties() {
        if (this.format.getValue() == null || ((String)this.format.getValue()).isEmpty()) {
            return null;
        }
        return this.formatProperties;
    }

    protected boolean acceptUninitializedField(Field f) {
        if (super.acceptUninitializedField(f)) {
            return true;
        }
        return FORMAT_PROPERTIES_NAME.equals(f.getName());
    }
}

