/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.config.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.LogicalTypeUtils;

public enum TalendType {
    LIST("id_List"),
    BOOLEAN("id_Boolean"),
    BYTE("id_Byte"),
    BYTES("id_byte[]"),
    CHARACTER("id_Character"),
    DATE("id_Date"),
    BIG_DECIMAL("id_BigDecimal"),
    DOUBLE("id_Double"),
    FLOAT("id_Float"),
    INTEGER("id_Integer"),
    LONG("id_Long"),
    OBJECT("id_Object"),
    SHORT("id_Short"),
    STRING("id_String");

    private static final Map<String, TalendType> talendTypes;
    private final String typeName;

    private TalendType(String typeName) {
        this.typeName = typeName;
    }

    public String getName() {
        return this.typeName;
    }

    public static TalendType get(String typeName) {
        TalendType talendType = talendTypes.get(typeName);
        if (talendType == null) {
            throw new IllegalArgumentException(String.format("Invalid value %s, it should be one of %s", typeName, talendTypes));
        }
        return talendType;
    }

    public static TalendType convertFromAvro(Schema avroType) {
        Schema type = AvroUtils.unwrapIfNullable((Schema)avroType);
        String logicalType = LogicalTypeUtils.getLogicalTypeName((Schema)type);
        if (logicalType != null) {
            return TalendType.getTalendByLogicalType(logicalType);
        }
        String javaClass = type.getProp("java-class");
        if (javaClass != null) {
            return TalendType.getTalendByJavaClass(javaClass);
        }
        return TalendType.getTalendByAvroType(type.getType());
    }

    private static TalendType getTalendByLogicalType(String logicalType) {
        switch (logicalType) {
            case "date": {
                return DATE;
            }
            case "time-micros": {
                return LONG;
            }
            case "time-millis": {
                return INTEGER;
            }
            case "timestamp-micros": {
                return DATE;
            }
            case "timestamp-millis": {
                return DATE;
            }
        }
        throw new UnsupportedOperationException("Unrecognized type " + logicalType);
    }

    private static TalendType getTalendByJavaClass(String javaClass) {
        switch (javaClass) {
            case "java.math.BigDecimal": {
                return BIG_DECIMAL;
            }
            case "java.lang.Byte": {
                return BYTE;
            }
            case "java.lang.Character": {
                return CHARACTER;
            }
            case "java.lang.Short": {
                return SHORT;
            }
            case "java.util.Date": {
                return DATE;
            }
        }
        throw new UnsupportedOperationException("Unrecognized java class " + javaClass);
    }

    private static TalendType getTalendByAvroType(Schema.Type type) {
        switch (type) {
            case ARRAY: {
                return LIST;
            }
            case BYTES: {
                return BYTES;
            }
            case INT: {
                return INTEGER;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case STRING: {
                return STRING;
            }
        }
        throw new UnsupportedOperationException("Unsupported avro type " + type);
    }

    static {
        talendTypes = new HashMap<String, TalendType>();
        for (TalendType talendType : TalendType.values()) {
            talendTypes.put(talendType.typeName, talendType);
        }
    }
}

