/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.config.jdbc;

import org.apache.avro.Schema;
import org.talend.components.common.config.jdbc.TalendType;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.LogicalTypeUtils;

public final class AvroTypeConverter {
    private AvroTypeConverter() {
    }

    public static Schema convertToAvro(TalendType talendType, String logicalType) {
        Schema fieldSchema = LogicalTypeUtils.getSchemaByLogicalType((String)logicalType);
        if (fieldSchema != null) {
            return fieldSchema;
        }
        switch (talendType) {
            case STRING: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case INTEGER: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case LONG: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case BYTE: {
                return AvroUtils._byte();
            }
            case SHORT: {
                return AvroUtils._short();
            }
            case CHARACTER: {
                return AvroUtils._character();
            }
            case BIG_DECIMAL: {
                return AvroUtils._decimal();
            }
            case DATE: {
                return AvroUtils._logicalTimestamp();
            }
        }
        throw new UnsupportedOperationException("Unrecognized type " + (Object)((Object)talendType));
    }
}

