/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.avro;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public final class RootSchemaUtils {
    private static final String MAIN_FIELD_NAME = "Main";
    private static final String OUTOFBAND_FIELD_NAME = "OutOfBand";

    private RootSchemaUtils() {
    }

    public static Schema createRootSchema(Schema mainSchema, Schema outOfBandSchema) {
        if (mainSchema == null || outOfBandSchema == null) {
            throw new IllegalArgumentException("Input schemas should be not null");
        }
        Schema rootSchema = (Schema)SchemaBuilder.record((String)"Root").fields().name(MAIN_FIELD_NAME).type(mainSchema).noDefault().name(OUTOFBAND_FIELD_NAME).type(outOfBandSchema).noDefault().endRecord();
        return rootSchema;
    }

    public static boolean isRootSchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        String schemaName = schema.getName();
        if (!"Root".equals(schemaName)) {
            return false;
        }
        if (Schema.Type.RECORD != schema.getType()) {
            return false;
        }
        Schema.Field main = schema.getField(MAIN_FIELD_NAME);
        Schema.Field outOfBand = schema.getField(OUTOFBAND_FIELD_NAME);
        return main != null && outOfBand != null;
    }

    public static Schema getMainSchema(Schema rootSchema) {
        if (!RootSchemaUtils.isRootSchema(rootSchema)) {
            throw new IllegalArgumentException("Input schema should be Root schema");
        }
        Schema mainSchema = rootSchema.getField(MAIN_FIELD_NAME).schema();
        return mainSchema;
    }

    public static Schema getOutOfBandSchema(Schema rootSchema) {
        if (!RootSchemaUtils.isRootSchema(rootSchema)) {
            throw new IllegalArgumentException("Input schema should be Root schema");
        }
        Schema outOfBandSchema = rootSchema.getField(OUTOFBAND_FIELD_NAME).schema();
        return outOfBandSchema;
    }
}

