/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.avro;

import java.sql.ResultSet;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.common.avro.JDBCAvroRegistry;
import org.talend.components.common.avro.JDBCAvroRegistryInfluencer;
import org.talend.daikon.avro.converter.AvroConverter;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public class JDBCResultSetIndexedRecordConverter
implements IndexedRecordConverter<ResultSet, IndexedRecord> {
    private Schema schema;
    private String[] names;
    protected transient AvroConverter[] fieldConverter;
    private int sizeInResultSet;
    private JDBCAvroRegistryInfluencer influencer;

    public Schema getSchema() {
        return this.schema;
    }

    protected JDBCAvroRegistry getRegistry() {
        return JDBCAvroRegistry.get();
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
        this.names = new String[this.getSchema().getFields().size()];
        this.fieldConverter = new AvroConverter[this.names.length];
        for (int j = 0; j < this.names.length; ++j) {
            Schema.Field f = (Schema.Field)this.getSchema().getFields().get(j);
            this.names[j] = f.name();
            JDBCAvroRegistry.JDBCConverter jdbcConverter = this.getRegistry().getConverter(f);
            if (this.influencer != null) {
                jdbcConverter.setInfluencer(this.influencer);
            }
            this.fieldConverter[j] = jdbcConverter;
        }
    }

    public void setSizeInResultSet(int sizeInResultSet) {
        this.sizeInResultSet = sizeInResultSet;
    }

    protected void resetSizeByResultSet(ResultSet resultSet) {
    }

    public Class<ResultSet> getDatumClass() {
        return ResultSet.class;
    }

    public ResultSet convertToDatum(IndexedRecord value) {
        throw new IndexedRecordConverter.UnmodifiableAdapterException();
    }

    public IndexedRecord convertToAvro(ResultSet value) {
        return new ResultSetIndexedRecord(value);
    }

    public void setInfluencer(JDBCAvroRegistryInfluencer influencer) {
        this.influencer = influencer;
    }

    private class ResultSetIndexedRecord
    implements IndexedRecord {
        private Object[] values;

        public ResultSetIndexedRecord(ResultSet resultSet) {
            JDBCResultSetIndexedRecordConverter.this.resetSizeByResultSet(resultSet);
            this.values = new Object[JDBCResultSetIndexedRecordConverter.this.names.length];
            for (int i = 0; i < this.values.length && (JDBCResultSetIndexedRecordConverter.this.sizeInResultSet <= 0 || i != JDBCResultSetIndexedRecordConverter.this.sizeInResultSet); ++i) {
                this.values[i] = JDBCResultSetIndexedRecordConverter.this.fieldConverter[i].convertToAvro((Object)resultSet);
            }
        }

        public Schema getSchema() {
            return JDBCResultSetIndexedRecordConverter.this.getSchema();
        }

        public void put(int i, Object v) {
            throw new IndexedRecordConverter.UnmodifiableAdapterException();
        }

        public Object get(int i) {
            return this.values[i];
        }
    }
}

