/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common;

import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.EnumProperty;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class SslProperties
extends PropertiesImpl {
    public Property<Boolean> useSsl = PropertyFactory.newBoolean((String)"useSsl", (Boolean)false);
    public EnumProperty<StoreType> trustStoreType = PropertyFactory.newEnum((String)"trustStoreType", StoreType.class);
    public Property<String> trustStorePath = PropertyFactory.newString((String)"trustStorePath");
    public Property<String> trustStorePassword = PropertyFactory.newString((String)"trustStorePassword");
    public Property<Boolean> needClientAuth = PropertyFactory.newBoolean((String)"needClientAuth", (Boolean)false);
    public EnumProperty<StoreType> keyStoreType = PropertyFactory.newEnum((String)"keyStoreType", StoreType.class);
    public Property<String> keyStorePath = PropertyFactory.newString((String)"keyStorePath");
    public Property<String> keyStorePassword = PropertyFactory.newString((String)"keyStorePassword");
    public Property<Boolean> verifyHost = PropertyFactory.newBoolean((String)"verifyHost", (Boolean)true);
    private FormType formType;

    public SslProperties(String name) {
        this(name, FormType.ALL);
    }

    public SslProperties(String name, FormType formType) {
        super(name);
        this.formType = formType;
    }

    public void setupLayout() {
        super.setupLayout();
        Form main = new Form((Properties)this, "Main");
        main.addRow(this.useSsl);
        main.addRow(this.trustStoreType);
        main.addRow(this.trustStorePath);
        main.addRow(Widget.widget(this.trustStorePassword).setWidgetType("widget.type.hidden.text"));
        if (this.formType == FormType.ALL) {
            main.addRow(this.needClientAuth);
            main.addRow(this.keyStoreType);
            main.addRow(this.keyStorePath);
            main.addRow(Widget.widget(this.keyStorePassword).setWidgetType("widget.type.hidden.text"));
            main.addRow(this.verifyHost);
        }
    }

    public void afterUseSsl() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterNeedClientAuth() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        if (form.getName().equals("Main")) {
            form.getWidget(this.trustStoreType).setVisible(this.useSsl);
            form.getWidget(this.trustStorePath).setVisible(this.useSsl);
            form.getWidget(this.trustStorePassword).setVisible(this.useSsl);
            if (this.formType == FormType.ALL) {
                form.getWidget(this.needClientAuth).setVisible(this.useSsl);
                form.getWidget(this.verifyHost).setVisible(this.useSsl);
                boolean needClient = (Boolean)this.useSsl.getValue() != false && (Boolean)this.needClientAuth.getValue() != false;
                form.getWidget(this.keyStoreType).setVisible(needClient);
                form.getWidget(this.keyStorePath).setVisible(needClient);
                form.getWidget(this.keyStorePassword).setVisible(needClient);
            }
        }
    }

    public static enum StoreType {
        JKS,
        PKCS12;

    }

    public static enum FormType {
        ALL,
        TRUST_ONLY;

    }
}

