/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common;

import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.components.api.component.Connector;
import org.talend.components.api.component.PropertyPathConnector;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.api.exception.error.ComponentsErrorCode;
import org.talend.components.api.properties.ComponentPropertiesImpl;
import org.talend.components.common.SchemaProperties;
import org.talend.daikon.NamedThing;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.property.Property;

public abstract class FixedConnectorsComponentProperties
extends ComponentPropertiesImpl {
    public FixedConnectorsComponentProperties(String name) {
        super(name);
    }

    public Schema getSchema(Connector connector, boolean isOutputConnection) {
        if (connector instanceof PropertyPathConnector) {
            NamedThing property = this.getProperty(((PropertyPathConnector)connector).getPropertyPath());
            if (property != null) {
                Property schemaProp = null;
                if (property instanceof SchemaProperties) {
                    SchemaProperties schemaProperties = (SchemaProperties)property;
                    schemaProp = schemaProperties.schema;
                } else if (property instanceof Property) {
                    schemaProp = (Property)property;
                }
                return schemaProp != null ? (Schema)schemaProp.getValue() : null;
            }
            throw new ComponentException((ErrorCode)ComponentsErrorCode.WRONG_CONNECTOR, ExceptionContext.build().put("properties", (Object)((Object)((Object)this)).getClass().getCanonicalName()));
        }
        return null;
    }

    protected abstract Set<PropertyPathConnector> getAllSchemaPropertiesConnectors(boolean var1);

    public Set<? extends Connector> getPossibleConnectors(boolean isOutputConnection) {
        return this.getAllSchemaPropertiesConnectors(isOutputConnection);
    }

    public Set<Connector> getAvailableConnectors(Set<? extends Connector> existingConnectors, boolean isOutputConnection) {
        return this.computeDiff(this.getAllSchemaPropertiesConnectors(isOutputConnection), existingConnectors);
    }

    private Set<Connector> computeDiff(Set<? extends Connector> allConnectors, Set<? extends Connector> existingConnections) {
        HashSet<Connector> diff = new HashSet<Connector>(allConnectors);
        if (existingConnections != null) {
            diff.removeAll(existingConnections);
        }
        return diff;
    }

    public void setConnectedSchema(Connector connector, Schema schema, boolean isOutputConnection) {
        if (connector instanceof PropertyPathConnector) {
            NamedThing property = this.getProperty(((PropertyPathConnector)connector).getPropertyPath());
            if (property != null) {
                if (property instanceof SchemaProperties) {
                    SchemaProperties schemaProperties = (SchemaProperties)property;
                    schemaProperties.schema.setValue((Object)schema);
                } else if (property instanceof Property) {
                    ((Property)property).setValue((Object)schema);
                }
            } else {
                throw new ComponentException((ErrorCode)ComponentsErrorCode.WRONG_CONNECTOR, ExceptionContext.build().put("properties", (Object)((Object)((Object)this)).getClass().getCanonicalName()));
            }
        }
    }
}

