/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common;

import java.util.Arrays;
import java.util.List;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class EncodingTypeProperties
extends PropertiesImpl {
    public static final String ENCODING_TYPE_UTF_8 = "UTF-8";
    public static final String ENCODING_TYPE_ISO_8859_15 = "ISO-8859-15";
    public static final String ENCODING_TYPE_CUSTOM = "CUSTOM";
    public Property<String> encodingType = PropertyFactory.newString((String)"encodingType");
    public Property<String> customEncoding = PropertyFactory.newString((String)"customEncoding").setRequired();

    public EncodingTypeProperties(String name) {
        super(name);
    }

    public void setupProperties() {
        super.setupProperties();
        List<String> defaultEncodings = this.getDefaultEncodings();
        if (defaultEncodings.size() > 0) {
            this.encodingType.setPossibleValues(this.getProperties());
            this.encodingType.setValue((Object)defaultEncodings.get(0));
        }
    }

    public void setupLayout() {
        super.setupLayout();
        Form form = Form.create((Properties)this, (String)"Main");
        form.addRow(Widget.widget(this.encodingType).setWidgetType("widget.type.enumeration"));
        form.addColumn(this.customEncoding);
    }

    public void afterEncodingType() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        if (form.getName().equals("Main")) {
            boolean isCustom = ENCODING_TYPE_CUSTOM.equals(this.encodingType.getValue());
            form.getWidget(this.customEncoding.getName()).setHidden(!isCustom);
        }
    }

    public List<String> getDefaultEncodings() {
        return Arrays.asList(ENCODING_TYPE_ISO_8859_15, ENCODING_TYPE_UTF_8, ENCODING_TYPE_CUSTOM);
    }

    public String getEncoding() {
        if (!ENCODING_TYPE_CUSTOM.equals(this.encodingType.getValue())) {
            return (String)this.encodingType.getValue();
        }
        return (String)this.customEncoding.getValue();
    }
}

