/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.collect.ForwardingMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.mining.Segment;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasResultFields;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.TargetField;

public abstract class SegmentResult
extends ForwardingMap<String, Object>
implements HasEntityId,
HasResultFields {
    private Segment segment = null;
    private Map<String, ?> results = null;

    SegmentResult(Segment segment, Map<String, ?> results) {
        this.setSegment(segment);
        this.setResults(results);
    }

    protected abstract ModelEvaluator<?> getModelEvaluator();

    public Map<String, Object> delegate() {
        Map<String, Object> results = this.getResults();
        return results;
    }

    @Override
    public List<TargetField> getTargetFields() {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        return modelEvaluator.getTargetFields();
    }

    @Override
    public List<OutputField> getOutputFields() {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        return modelEvaluator.getOutputFields();
    }

    public Object getTargetValue() {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        String targetName = modelEvaluator.getTargetName();
        return this.get(targetName);
    }

    public Number getWeight() {
        Segment segment = this.getSegment();
        return segment.getWeight();
    }

    public Segment getSegment() {
        return this.segment;
    }

    private void setSegment(Segment segment) {
        this.segment = Objects.requireNonNull(segment);
    }

    public Map<String, ?> getResults() {
        return this.results;
    }

    private void setResults(Map<String, ?> results) {
        this.results = Objects.requireNonNull(results);
    }
}

