/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.writers;

import cz.drg.clasificator.args.argevaluation.ConfigurableIOClass;
import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.setting.program.IOclass;
import cz.drg.clasificator.util.HeaderList;
import cz.drg.clasificator.util.InsertQueryBatch;
import cz.drg.clasificator.util.OutputHelper;
import cz.drg.clasificator.writers.OutputWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Scanner;

public class DBWriter
implements OutputWriter,
ConfigurableIOClass {
    private boolean isService = false;
    private IOclass ioClass;
    private String username;
    private String password;
    private Connection connection;

    @Override
    public void writeOutput(HeaderList originalInput, List<List<String>> lines) {
        if (!this.isConnected()) {
            this.connection = this.createNewConnection();
        }
        InsertQueryBatch insertQueryBatch = new InsertQueryBatch(this.ioClass);
        try {
            this.prepareForSpecificDbVendors(this.connection);
            insertQueryBatch.createQueries(originalInput, lines);
            Statement filledStatement = insertQueryBatch.fillStatement(this.connection.createStatement());
            filledStatement.executeBatch();
            filledStatement.close();
            this.disconnect();
        }
        catch (SQLException ex) {
            OutputHelper.errLog("Insert batch was:");
            OutputHelper.errLog(insertQueryBatch.toString());
            OutputHelper.errLog(ex.getMessage());
            this.disconnect();
            throw new ShutdownException("Error when writting into the database.");
        }
    }

    @Override
    @Deprecated
    public void writeOutput(List<String> lines) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private Connection createNewConnection() {
        String databaseUrl = this.getTargetDatabaseUrl();
        OutputHelper.errLog("Creating new connection to database " + databaseUrl + " for writing.");
        if (this.username != null && this.password != null) {
            return this.connect(databaseUrl);
        }
        if (this.hasDBCredentialsInConfig()) {
            this.username = this.ioClass.getDatabaseUser();
            this.password = this.ioClass.getDatabasePassword();
        } else {
            Scanner scan = new Scanner(System.in);
            OutputHelper.dualLog("Enter username:");
            this.username = scan.nextLine();
            OutputHelper.dualLog("Enter password:");
            this.password = scan.nextLine();
        }
        return this.connect(databaseUrl);
    }

    private void prepareForSpecificDbVendors(Connection conn) throws SQLException {
        if (this.ioClass.getDatabaseConnection().contains("jdbc:oracle:thin:@")) {
            PreparedStatement prepareStatement = conn.prepareStatement("ALTER SESSION SET NLS_NUMERIC_CHARACTERS = '.,'");
            prepareStatement.execute();
            prepareStatement.close();
        }
    }

    @Override
    public void setIoClass(IOclass config) {
        if (config == null) {
            OutputHelper.dualLog("No database configuration set for this class. Add <databaseConnection> setting into the related <IOclass> setting first!");
            System.exit(-1);
        }
        this.ioClass = config;
    }

    @Override
    public void clear() {
        if (!this.isConnected()) {
            this.connection = this.createNewConnection();
        }
        if (!this.isService) {
            try {
                PreparedStatement prepareStatement = this.connection.prepareStatement("TRUNCATE TABLE " + this.getTargetTable());
                prepareStatement.executeUpdate();
                prepareStatement.close();
            }
            catch (SQLException ex) {
                OutputHelper.dualLog(ex.getMessage());
                throw new ShutdownException("Error when cleaning output database table!");
            }
            finally {
                this.disconnect();
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    private Connection connect(String databaseUrl) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(databaseUrl, this.username, this.password);
            connection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            OutputHelper.dualLog(ex.getMessage());
            throw new ShutdownException(String.format("Connection to database at '%s' could not be established.", databaseUrl));
        }
        return connection;
    }

    private void disconnect() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (SQLException ex) {
            OutputHelper.dualLog(ex.getMessage());
            throw new ShutdownException("Error when closing connection to database!");
        }
    }

    private String getTargetDatabaseUrl() {
        return this.ioClass.getDatabaseConnection();
    }

    private String getTargetTable() {
        return this.ioClass.getDatabaseTargetTable();
    }

    private boolean isConnected() {
        return this.connection != null;
    }

    private boolean hasDBCredentialsInConfig() {
        return this.ioClass.getDatabaseUser() != null && this.ioClass.getDatabasePassword() != null;
    }

    public boolean isService() {
        return this.isService;
    }

    public void setIsService(boolean isService) {
        this.isService = isService;
    }
}

