/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import cz.drg.clasificator.setting.program.IOclass;
import cz.drg.clasificator.util.HeaderList;
import cz.drg.clasificator.util.InsertQuery;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class InsertQueryBatch {
    private List<InsertQuery> queries = new ArrayList<InsertQuery>();
    private IOclass ioClass;

    public InsertQueryBatch(IOclass ioClass) {
        if (ioClass == null) {
            throw new IllegalArgumentException("IOClass parameter '" + ioClass + "' is invalid!");
        }
        this.ioClass = ioClass;
    }

    public Statement fillStatement(Statement statement) throws SQLException {
        for (InsertQuery query : this.queries) {
            statement.addBatch(query.toString());
        }
        return statement;
    }

    public void createQueries(HeaderList originalInput, List<List<String>> evaluatedOutput) {
        List<String> headers = this.getHeaders(originalInput, evaluatedOutput);
        List<List<String>> values = this.getValues(originalInput, evaluatedOutput);
        for (List<String> row : values) {
            InsertQuery query = new InsertQuery(this.getTargetTable());
            query.setHeaders(headers);
            query.setValues(row);
            this.prepareForSpecificDbVendors(query);
            this.queries.add(query);
        }
    }

    private List<String> getHeaders(HeaderList originalInput, List<List<String>> evaluatedOutput) {
        List<List<String>> values = originalInput.getValues();
        ArrayList<String> headers = new ArrayList<String>();
        headers.addAll(values.get(0).stream().map(value -> value.replaceAll("\"", "")).collect(Collectors.toList()));
        headers.addAll((Collection)evaluatedOutput.get(0));
        return headers;
    }

    private List<List<String>> getValues(HeaderList originalInput, List<List<String>> evaluatedOutput) {
        List<List<String>> originalValues = originalInput.getValues();
        ArrayList<List<String>> allValues = new ArrayList<List<String>>();
        for (int i = 1; i <= originalInput.numOfLines(); ++i) {
            ArrayList row = new ArrayList();
            row.addAll(originalValues.get(i).stream().map(value -> value.replaceAll("\"", "")).collect(Collectors.toList()));
            row.addAll(evaluatedOutput.get(i));
            allValues.add(row);
        }
        return allValues;
    }

    private String getTargetTable() {
        return this.ioClass.getDatabaseTargetTable();
    }

    private void prepareForSpecificDbVendors(InsertQuery query) {
        if (this.ioClass.getDatabaseConnection().contains("jdbc:oracle:thin:@")) {
            query.setDbType(InsertQuery.DatabaseType.ORACLE);
        } else if (this.ioClass.getDatabaseConnection().contains("jdbc:informix-sqli:")) {
            query.setDbType(InsertQuery.DatabaseType.INFORMIX);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (InsertQuery query : this.queries) {
            sb.append(query);
            sb.append("\n");
        }
        return "InsertQueryBatch{\n" + sb + '}';
    }
}

