/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.readers;

import cz.drg.clasificator.readers.BaseReader;
import cz.drg.clasificator.setting.ProgramSettings;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.util.OutputHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class CsvReader
extends BaseReader {
    private static String DEFAULT_CHARSET;
    private static String DEFAULT_DELIMITER;
    private static String DEFAULT_INPUT_FILEPATH;
    private static String DEFAULT_PMML_INPUT_FILEPATH;
    private static File DEFAULT_INPUT;
    private static ZipFile DEFAULT_PMML_INPUT;
    private static Charset CHARSET;
    private final int batchSize = Settings.getProgramSettings().getEvaluationBatchSize();
    private boolean hasNextBatch = true;
    private boolean isFirstBatch = true;
    private BufferedReader reader;
    private long totalEntries = -1L;
    private String readAhead = null;

    public CsvReader(File input, ZipFile pmmlInput, String delimiter, String charset) {
        super(pmmlInput, delimiter);
        try {
            CHARSET = Charset.forName(charset);
        }
        catch (UnsupportedCharsetException ex) {
            OutputHelper.dualLog(String.format("Charset with name '%s' is not supported by installed java-runtime environment. Using default charset from settings '%s'.", charset, DEFAULT_CHARSET));
            CHARSET = Charset.forName(DEFAULT_CHARSET);
        }
        try {
            this.reader = Files.newBufferedReader(input.toPath(), CHARSET);
        }
        catch (IOException ex) {
            OutputHelper.dualLog("Error occured while opening the file " + input.getPath() + ".");
            OutputHelper.dualLog(ex.getMessage());
            System.exit(500);
        }
        this.init();
    }

    public CsvReader(File input, String delimiter, String charset) {
        this(input, DEFAULT_PMML_INPUT, delimiter, charset);
    }

    public CsvReader(File source) {
        this(source, DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }

    public CsvReader(File input, ZipFile pmmlInput) {
        this(input, pmmlInput, DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }

    public CsvReader(String input, String delimiter, String charset) {
        this(new File(input), DEFAULT_PMML_INPUT, delimiter, charset);
    }

    public CsvReader(String input, String delimiter) {
        this(new File(input), DEFAULT_PMML_INPUT, delimiter, DEFAULT_CHARSET);
    }

    public CsvReader(String input) {
        this(new File(input), DEFAULT_PMML_INPUT, DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }

    public CsvReader() {
        this(DEFAULT_INPUT, DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }

    private static void loadDefaults() {
        ProgramSettings programSettings = Settings.getProgramSettings();
        DEFAULT_INPUT_FILEPATH = programSettings.getDefaultInputPath();
        DEFAULT_PMML_INPUT_FILEPATH = programSettings.getDefaultPmmlPath();
        DEFAULT_CHARSET = programSettings.getDefaultCharset();
        DEFAULT_DELIMITER = programSettings.getDefaultDelimiter();
        DEFAULT_INPUT = new File(DEFAULT_INPUT_FILEPATH);
        try {
            DEFAULT_PMML_INPUT = new ZipFile(DEFAULT_PMML_INPUT_FILEPATH);
        }
        catch (IOException ex) {
            OutputHelper.dualLog("Error loading default PMML zip file: '" + DEFAULT_PMML_INPUT_FILEPATH + "'");
            System.exit(-1);
        }
    }

    @Override
    protected List<String> getData() {
        ArrayList<String> result = new ArrayList<String>();
        int size = this.isFirstBatch ? this.batchSize + 1 : this.batchSize;
        for (int i = 0; i < size; ++i) {
            String line = null;
            if (this.readAhead != null) {
                result.add(this.readAhead);
                this.readAhead = null;
                continue;
            }
            try {
                line = this.reader.readLine();
            }
            catch (IOException ex) {
                OutputHelper.dualLog("Error occured while reading the file.");
                OutputHelper.dualLog(ex.getMessage());
                return result;
            }
            if (line == null) break;
            result.add(line);
        }
        this.totalEntries += (long)result.size();
        this.isFirstBatch = false;
        try {
            this.readAhead = this.reader.readLine();
            this.hasNextBatch = this.readAhead != null;
        }
        catch (IOException ex) {
            Logger.getLogger(CsvReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    @Override
    public boolean hasNextEntryBatch() {
        return this.hasNextBatch;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CsvReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        CsvReader.loadDefaults();
    }
}

