/*
 * Decompiled with CFR 0.152.
 */
package routines.system.xml.sax;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class NamespaceFilter
extends XMLFilterImpl {
    private Deque<Context> nsStack = new ArrayDeque<Context>();
    private Matcher matcher;

    public NamespaceFilter() {
    }

    public NamespaceFilter(ContentHandler contentHandler, Matcher matcher) {
        this.setContentHandler(contentHandler);
        this.setMatcher(matcher);
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.matchNamespace(uri)) {
            this.nsStack.peek().setMapping(prefix, uri);
        } else {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.nsStack.isEmpty()) {
            return;
        }
        String uri = this.nsStack.peek().getUri(prefix);
        if (uri != null && this.matchNamespace(uri)) {
            return;
        }
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.nsStack.push(new Context());
        if (this.matchNamespace(uri)) {
            super.startElement("", localName, localName, atts);
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.matchNamespace(uri)) {
            super.endElement("", localName, localName);
        } else {
            super.endElement(uri, localName, qName);
        }
        this.nsStack.pop();
    }

    private boolean matchNamespace(String uri) {
        return uri.length() != 0 && this.matcher != null && this.matcher.matches(uri);
    }

    static class Context {
        private Map<String, String> prefixToUriMap;

        Context() {
        }

        public void setMapping(String prefix, String uri) {
            if (this.prefixToUriMap == null) {
                this.prefixToUriMap = new HashMap<String, String>();
            }
            this.prefixToUriMap.put(uri, prefix);
        }

        public String getUri(String prefix) {
            return this.prefixToUriMap != null ? this.prefixToUriMap.get(prefix) : null;
        }
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

