/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import routines.system.NoHeaderObjectInputStream;
import routines.system.NoHeaderObjectOutputStream;
import routines.system.TraceBean;
import routines.system.TraceDataBean;
import routines.system.TraceStatusBean;

public class RunTrace
implements Runnable {
    private boolean openSocket = true;
    private ConcurrentHashMap<String, TraceDataBean> processTraces = new ConcurrentHashMap();
    private Map<String, String> subjobMap = new HashMap<String, String>();
    private Socket s;
    private NoHeaderObjectOutputStream oos;
    private NoHeaderObjectInputStream ois;
    private boolean jobIsFinished = false;
    private String str = "";
    private Thread t;
    private String connectionId = "";

    public void openSocket(boolean openSocket) {
        this.openSocket = openSocket;
    }

    public void startThreadTrace(String clientHost, int portTraces) throws IOException, UnknownHostException {
        if (!this.openSocket) {
            return;
        }
        System.out.println("[trace] connecting to socket on port " + portTraces);
        this.s = new Socket(clientHost, portTraces);
        this.oos = new NoHeaderObjectOutputStream(this.s.getOutputStream());
        System.out.println("[trace] connected");
        this.t = new Thread(this);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RunTrace runTrace = this;
        synchronized (runTrace) {
            try {
                while (!this.jobIsFinished) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException e) {
                System.out.println("[trace] interrupted");
            }
        }
    }

    public void stopThreadTrace() {
        if (!this.openSocket) {
            return;
        }
        this.jobIsFinished = true;
        try {
            this.oos.close();
            this.s.close();
            System.out.println("[trace] disconnected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean isNextRow() {
        if (!this.openSocket) {
            return false;
        }
        try {
            this.askForStatus();
            this.ois = new NoHeaderObjectInputStream(this.s.getInputStream(), TraceDataBean.class, TraceStatusBean.class);
            TraceBean traceBean = (TraceBean)this.ois.readObject();
            return traceBean.equals(TraceStatusBean.NEXT_ROW);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized boolean isNextBreakpoint() {
        if (!this.openSocket) {
            return false;
        }
        try {
            this.askForStatus();
            this.ois = new NoHeaderObjectInputStream(this.s.getInputStream(), TraceDataBean.class, TraceStatusBean.class);
            TraceBean traceBean = (TraceBean)this.ois.readObject();
            return traceBean.equals(TraceStatusBean.NEXT_BREAKPOINT);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized void waitForUserAction() throws InterruptedException {
        if (!this.openSocket) {
            return;
        }
        try {
            boolean action = false;
            this.oos.writeObject(TraceStatusBean.UI_STATUS);
            do {
                this.ois = new NoHeaderObjectInputStream(this.s.getInputStream(), TraceDataBean.class, TraceStatusBean.class);
                TraceBean traceBean = (TraceBean)this.ois.readObject();
                if (traceBean.equals(TraceStatusBean.STATUS_WAITING)) {
                    this.oos.writeObject(TraceStatusBean.UI_STATUS);
                    Thread.sleep(100L);
                    continue;
                }
                action = true;
            } while (!action);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isPause() {
        if (!this.openSocket) {
            return false;
        }
        try {
            this.askForStatus();
            this.ois = new NoHeaderObjectInputStream(this.s.getInputStream(), TraceDataBean.class, TraceStatusBean.class);
            TraceBean traceBean = (TraceBean)this.ois.readObject();
            return traceBean.equals(TraceStatusBean.PAUSE);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private synchronized void askForStatus() throws IOException {
        this.oos.writeObject(TraceStatusBean.ID_STATUS);
    }

    public synchronized void sendTrace(String connectionId, String startNodeCid, LinkedHashMap datas) throws IOException {
        if (!this.openSocket) {
            return;
        }
        this.subjobMap.put(connectionId, startNodeCid);
        Iterator<Map.Entry<String, String>> ite = this.subjobMap.entrySet().iterator();
        boolean sameSub = false;
        while (ite.hasNext()) {
            Map.Entry<String, String> en = ite.next();
            if (en.getKey().equals(connectionId) || !en.getValue().equals(startNodeCid)) continue;
            sameSub = true;
            break;
        }
        if (sameSub && this.processTraces.size() > 1 && connectionId.equals(this.connectionId)) {
            return;
        }
        TraceDataBean bean = this.processTraces.containsKey(connectionId) ? this.processTraces.get(connectionId) : new TraceDataBean(connectionId);
        bean.setNbLine(bean.getNbLine() + 1);
        this.processTraces.put(connectionId, bean);
        bean.setData(datas);
        this.oos.writeUnshared(bean);
        this.oos.flush();
        this.connectionId = connectionId;
    }
}

