/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import routines.system.GlobalResource;
import routines.system.JobStructureCatcherUtils;

public class RunStat
implements Runnable {
    private boolean openSocket = true;
    private static boolean debug = false;
    public static int BEGIN = 0;
    public static int RUNNING = 1;
    public static int END = 2;
    public static int CLEAR = 3;
    public static int JOBDEFAULT = -1;
    public static int JOBSTART = 0;
    public static int JOBEND = 1;
    public static String TYPE0_JOB = "0";
    public static String TYPE1_CONNECTION = "1";
    private Map<String, StatBean> processStats = new HashMap<String, StatBean>();
    private List<String> keysList = new LinkedList<String>();
    private Socket s;
    private PrintWriter pred;
    private boolean jobIsFinished = false;
    private String str = "";
    long lastStatsUpdate = 0L;
    private Map<String, StatBean> processStats4Meter = new HashMap<String, StatBean>();
    private List<String> keysList4Meter = new LinkedList<String>();
    private String rootPid = null;
    private String fatherPid = null;
    private String pid = "0";
    private String jobName = null;

    public void openSocket(boolean openSocket) {
        this.openSocket = openSocket;
    }

    public void startThreadStat(String clientHost, int portStats) throws IOException, UnknownHostException {
        if (!this.openSocket) {
            Socket s = null;
            Object object = GlobalResource.resourceMap.get(portStats);
            OutputStream output = null;
            if (object == null || !(object instanceof Socket)) {
                String lastCallerJobName = new Exception().getStackTrace()[1].getClassName();
                System.err.println("The socket for statistics function is unavailable in job " + lastCallerJobName + "." + "\nUsually, please check the tRunJob, it should uncheck the option \"Use an independent process to run child job\".");
                output = System.out;
            } else {
                s = (Socket)object;
                output = s.getOutputStream();
            }
            if (debug) {
                output = System.out;
            }
            this.pred = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(output)), true);
            Thread t = new Thread(this);
            t.start();
            return;
        }
        System.out.println("[statistics] connecting to socket on port " + portStats);
        boolean isConnect = false;
        OutputStream output = null;
        try {
            this.s = new Socket(clientHost, portStats);
            isConnect = true;
        }
        catch (Exception e) {
            System.err.println("Unable to connect to " + clientHost + " on the port " + portStats);
        }
        if (isConnect) {
            GlobalResource.resourceMap.put(portStats, this.s);
            output = this.s.getOutputStream();
            System.out.println("[statistics] connected");
        } else {
            output = System.out;
            System.out.println("[statistics] connection refused");
        }
        if (debug) {
            output = System.out;
        }
        this.pred = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(output)), true);
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!debug) {
            RunStat runStat = this;
            synchronized (runStat) {
                try {
                    while (!this.jobIsFinished) {
                        this.sendMessages();
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("[statistics] interrupted");
                }
            }
        }
    }

    public void stopThreadStat() {
        this.jobIsFinished = true;
        try {
            this.sendMessages();
            if (!this.openSocket) {
                return;
            }
            if (this.pred != null) {
                this.pred.close();
            }
            if (this.s != null && !this.s.isClosed()) {
                this.s.close();
            }
            System.out.println("[statistics] disconnected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendMessages() {
        for (String curKey : this.keysList) {
            StatBean sb = this.processStats.get(curKey);
            int jobStat = sb.getJobStat();
            if (jobStat == JOBDEFAULT) {
                this.str = String.valueOf(TYPE1_CONNECTION) + "|" + this.rootPid + "|" + this.fatherPid + "|" + this.pid + "|" + sb.getConnectionId();
                if (sb.getState() == CLEAR) {
                    this.str = String.valueOf(this.str) + "|clear";
                } else {
                    this.str = sb.getExec() == null ? String.valueOf(this.str) + "|" + sb.getNbLine() + "|" + (sb.getEndTime() - sb.getStartTime()) : String.valueOf(this.str) + "|" + sb.getExec();
                    if (sb.getState() != RUNNING) {
                        this.str = String.valueOf(this.str) + "|" + (sb.getState() == BEGIN ? "start" : "stop");
                    }
                    if (sb.isClearAfterSend()) {
                        this.processStats.remove(curKey);
                    }
                }
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
                String jobStatStr = "";
                String itemId = sb.getItemId();
                String string = itemId = itemId == null ? "" : itemId;
                if (jobStat == JOBSTART) {
                    jobStatStr = String.valueOf(this.jobName) + "|" + "start job" + "|" + itemId + "|" + simpleDateFormat.format(new Date(sb.getStartTime()));
                } else if (jobStat == JOBEND) {
                    jobStatStr = String.valueOf(this.jobName) + "|" + "end job" + "|" + itemId + "|" + simpleDateFormat.format(new Date(sb.getEndTime()));
                }
                this.str = String.valueOf(TYPE0_JOB) + "|" + this.rootPid + "|" + this.fatherPid + "|" + this.pid + "|" + jobStatStr;
            }
            this.pred.println(this.str);
        }
        this.keysList.clear();
    }

    public synchronized StatBean log(String connectionId, int mode, int nbLine) {
        String key = connectionId;
        if (connectionId.contains(".")) {
            String firstKey = null;
            String connectionName = connectionId.split("\\.")[0];
            int nbKeys = 0;
            for (String myKey : this.keysList4Meter) {
                if (!myKey.startsWith(String.valueOf(connectionName) + ".")) continue;
                if (firstKey == null) {
                    firstKey = myKey;
                }
                if (++nbKeys == 4) break;
            }
            if (nbKeys == 4) {
                this.keysList4Meter.remove(firstKey);
            }
        }
        if (this.keysList4Meter.contains(key)) {
            int keyNb = this.keysList4Meter.indexOf(key);
            this.keysList4Meter.remove(key);
            this.keysList4Meter.add(keyNb, key);
        } else {
            this.keysList4Meter.add(key);
        }
        StatBean bean = this.processStats4Meter.containsKey(key) ? this.processStats4Meter.get(key) : new StatBean(connectionId);
        bean.setNbLine(bean.getNbLine() + nbLine);
        this.processStats4Meter.put(key, bean);
        if (mode == BEGIN) {
            bean.setNbLine(0);
            bean.setStartTime(System.currentTimeMillis());
        } else if (mode == END) {
            bean.setEndTime(System.currentTimeMillis());
            this.processStats4Meter.remove(key);
            this.keysList4Meter.clear();
        }
        return bean;
    }

    public synchronized boolean log(Map<String, Object> resourceMap, String iterateId, String connectionUniqueName, int mode, int nbLine, JobStructureCatcherUtils jscu, String sourceNodeId, String sourceNodeComponent, String targetNodeId, String targetNodeComponent, String lineType) {
        if (resourceMap.get("inIterateVComp") == null || !((Boolean)resourceMap.get("inIterateVComp")).booleanValue()) {
            StatBean bean = this.log(connectionUniqueName, mode, nbLine);
            jscu.addConnectionMessage(sourceNodeId, sourceNodeComponent, false, lineType, String.valueOf(connectionUniqueName) + iterateId, bean.getNbLine(), bean.getStartTime(), bean.getEndTime());
            jscu.addConnectionMessage(targetNodeId, targetNodeComponent, true, "input", String.valueOf(connectionUniqueName) + iterateId, bean.getNbLine(), bean.getStartTime(), bean.getEndTime());
            return true;
        }
        return false;
    }

    public synchronized void updateStat(Map<String, Object> resourceMap, String iterateId, int mode, int nbLine, String ... connectionUniqueNames) {
        if (resourceMap.get("inIterateVComp") == null || !((Boolean)resourceMap.get("inIterateVComp")).booleanValue()) {
            String[] stringArray = connectionUniqueNames;
            int n = connectionUniqueNames.length;
            int n2 = 0;
            while (n2 < n) {
                String connectionUniqueName = stringArray[n2];
                this.updateStatOnConnection(String.valueOf(connectionUniqueName) + iterateId, mode, nbLine);
                ++n2;
            }
        }
    }

    public synchronized boolean updateStatAndLog(boolean execStat, boolean enableLogStash, Map<String, Object> resourceMap, String iterateId, String connectionUniqueName, int mode, int nbLine, JobStructureCatcherUtils jscu, String sourceNodeId, String sourceNodeComponent, String targetNodeId, String targetNodeComponent, String lineType) {
        if (execStat) {
            this.updateStat(resourceMap, iterateId, mode, nbLine, connectionUniqueName);
        }
        if (enableLogStash) {
            return this.log(resourceMap, iterateId, connectionUniqueName, mode, nbLine, jscu, sourceNodeId, sourceNodeComponent, targetNodeId, targetNodeComponent, lineType);
        }
        return false;
    }

    public synchronized void updateStatOnConnection(Map<String, Object> resourceMap, String iterateId, int mode, int nbLine, String ... connectionUniqueNames) {
        if (resourceMap.get("inIterateVComp") == null) {
            String[] stringArray = connectionUniqueNames;
            int n = connectionUniqueNames.length;
            int n2 = 0;
            while (n2 < n) {
                String connectionUniqueName = stringArray[n2];
                this.updateStatOnConnection(String.valueOf(connectionUniqueName) + iterateId, mode, nbLine);
                ++n2;
            }
        }
    }

    public synchronized void log(Map<String, Object> resourceMap, String iterateId, int mode, int nbLine, String ... connectionUniqueNames) {
        if (resourceMap.get("inIterateVComp") == null) {
            String[] stringArray = connectionUniqueNames;
            int n = connectionUniqueNames.length;
            int n2 = 0;
            while (n2 < n) {
                String connectionUniqueName = stringArray[n2];
                this.log(String.valueOf(connectionUniqueName) + iterateId, mode, nbLine);
                ++n2;
            }
        }
    }

    public synchronized void log(Map<String, Object> resourceMap, String iterateId, int mode, int nbLine, String connectionUniqueName) {
        if (resourceMap.get("inIterateVComp") == null) {
            this.log(String.valueOf(connectionUniqueName) + iterateId, mode, nbLine);
        }
    }

    public synchronized void updateStatAndLog(boolean execStat, boolean enableLogStash, Map<String, Object> resourceMap, String iterateId, int mode, int nbLine, String ... connectionUniqueNames) {
        if (execStat) {
            this.updateStatOnConnection(resourceMap, iterateId, mode, nbLine, connectionUniqueNames);
        }
        if (enableLogStash) {
            this.log(resourceMap, iterateId, mode, nbLine, connectionUniqueNames);
        }
    }

    public synchronized void updateStatOnConnection(String iterateId, int mode, int nbLine, String ... connectionUniqueNames) {
        String[] stringArray = connectionUniqueNames;
        int n = connectionUniqueNames.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionUniqueName = stringArray[n2];
            this.updateStatOnConnection(String.valueOf(connectionUniqueName) + iterateId, mode, nbLine);
            ++n2;
        }
    }

    public synchronized void log(String iterateId, int mode, int nbLine, String ... connectionUniqueNames) {
        String[] stringArray = connectionUniqueNames;
        int n = connectionUniqueNames.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionUniqueName = stringArray[n2];
            this.log(String.valueOf(connectionUniqueName) + iterateId, mode, nbLine);
            ++n2;
        }
    }

    public synchronized void log(String iterateId, int mode, int nbLine, String connectionUniqueName) {
        this.log(String.valueOf(connectionUniqueName) + iterateId, mode, nbLine);
    }

    public synchronized void updateStatAndLog(boolean execStat, boolean enableLogStash, String iterateId, int mode, int nbLine, String ... connectionUniqueNames) {
        if (execStat) {
            this.updateStatOnConnection(iterateId, mode, nbLine, connectionUniqueNames);
        }
        if (enableLogStash) {
            this.log(iterateId, mode, nbLine, connectionUniqueNames);
        }
    }

    public synchronized void updateStatOnConnectionAndLog(Map<String, Object> globalMap, int iterateLoop, String iterateId, boolean execStat, boolean enableLogStash, int nbLine, String ... connectionUniqueNames) {
        String[] stringArray = connectionUniqueNames;
        int n = connectionUniqueNames.length;
        int n2 = 0;
        while (n2 < n) {
            int step;
            String connectionUniqueName = stringArray[n2];
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)globalMap.get("concurrentHashMap");
            concurrentHashMap.putIfAbsent(String.valueOf(connectionUniqueName) + iterateLoop, new AtomicInteger(0));
            AtomicInteger stats = (AtomicInteger)concurrentHashMap.get(String.valueOf(connectionUniqueName) + iterateLoop);
            int n3 = step = stats.incrementAndGet() <= 1 ? 0 : 1;
            if (execStat) {
                this.updateStatOnConnection(String.valueOf(connectionUniqueName) + iterateId, step, nbLine);
            }
            if (enableLogStash) {
                this.log(String.valueOf(connectionUniqueName) + iterateId, step, nbLine);
            }
            ++n2;
        }
    }

    public synchronized void updateStatOnConnectionAndLog(Map<String, Object> resourceMap, Map<String, Object> globalMap, int iterateLoop, String iterateId, boolean execStat, boolean enableLogStash, int nbLine, String ... connectionUniqueNames) {
        String[] stringArray = connectionUniqueNames;
        int n = connectionUniqueNames.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionUniqueName = stringArray[n2];
            if (resourceMap.get("inIterateVComp") == null) {
                int step;
                ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)globalMap.get("concurrentHashMap");
                concurrentHashMap.putIfAbsent(String.valueOf(connectionUniqueName) + iterateLoop, new AtomicInteger(0));
                AtomicInteger stats = (AtomicInteger)concurrentHashMap.get(String.valueOf(connectionUniqueName) + iterateLoop);
                int n3 = step = stats.incrementAndGet() <= 1 ? 0 : 1;
                if (execStat) {
                    this.updateStatOnConnection(String.valueOf(connectionUniqueName) + iterateId, step, nbLine);
                }
                if (enableLogStash) {
                    this.log(String.valueOf(connectionUniqueName) + iterateId, step, nbLine);
                }
            }
            ++n2;
        }
    }

    public synchronized void updateStatOnConnection(String connectionId, int mode, int nbLine) {
        String key = connectionId;
        if (connectionId.contains(".")) {
            String firstKey = null;
            String connectionName = connectionId.split("\\.")[0];
            int nbKeys = 0;
            for (String myKey : this.keysList) {
                if (!myKey.startsWith(String.valueOf(connectionName) + ".")) continue;
                if (firstKey == null) {
                    firstKey = myKey;
                }
                if (++nbKeys == 4) break;
            }
            if (nbKeys == 4) {
                this.keysList.remove(firstKey);
            }
        }
        if (this.keysList.contains(key)) {
            int keyNb = this.keysList.indexOf(key);
            this.keysList.remove(key);
            this.keysList.add(keyNb, key);
        } else {
            this.keysList.add(key);
        }
        StatBean bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setState(mode);
        bean.setEndTime(System.currentTimeMillis());
        bean.setNbLine(bean.getNbLine() + nbLine);
        this.processStats.put(key, bean);
        if (mode == BEGIN) {
            bean.setNbLine(0);
            long newStatsUpdate = System.currentTimeMillis();
            if (this.lastStatsUpdate == 0L || this.lastStatsUpdate + 250L < newStatsUpdate) {
                this.sendMessages();
                this.lastStatsUpdate = newStatsUpdate;
            }
            bean.setStartTime(System.currentTimeMillis());
        }
        if (debug) {
            this.sendMessages();
        }
    }

    public synchronized void updateStatOnConnection(String connectionId, int mode, String exec) {
        String key = String.valueOf(connectionId) + "|" + mode;
        boolean clearAfterSend = false;
        if (connectionId.startsWith("iterate")) {
            key = String.valueOf(connectionId) + "|" + mode + "|" + exec;
            clearAfterSend = true;
        } else if (connectionId.contains(".")) {
            String firstKey = null;
            String connectionName = connectionId.split(".")[0];
            int nbKeys = 0;
            for (String myKey : this.keysList) {
                if (!myKey.startsWith(String.valueOf(connectionName) + ".")) continue;
                if (firstKey == null) {
                    firstKey = myKey;
                }
                if (++nbKeys == 4) break;
            }
            if (nbKeys == 4) {
                this.keysList.remove(firstKey);
            }
        }
        if (this.keysList.contains(key)) {
            this.keysList.remove(key);
        }
        this.keysList.add(key);
        StatBean bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setState(mode);
        bean.setExec(exec);
        bean.setClearAfterSend(clearAfterSend);
        this.processStats.put(key, bean);
        long newStatsUpdate = System.currentTimeMillis();
        if (this.lastStatsUpdate == 0L || this.lastStatsUpdate + 250L < newStatsUpdate) {
            this.sendMessages();
            this.lastStatsUpdate = newStatsUpdate;
        }
    }

    public synchronized void updateStatOnIterate(String connectionId, int mode) {
        String key = String.valueOf(connectionId) + "|" + mode;
        String exec = "";
        StatBean bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setNbLine(bean.getNbLine() + 1);
        exec = "exec" + bean.getNbLine();
        this.processStats.put(key, bean);
        key = String.valueOf(connectionId) + "|" + mode + "|" + exec;
        if (this.keysList.contains(key)) {
            this.keysList.remove(key);
        }
        this.keysList.add(key);
        bean = this.processStats.containsKey(key) ? this.processStats.get(key) : new StatBean(connectionId);
        bean.setState(mode);
        bean.setExec(exec);
        bean.setClearAfterSend(true);
        this.processStats.put(key, bean);
        long newStatsUpdate = System.currentTimeMillis();
        if (this.lastStatsUpdate == 0L || this.lastStatsUpdate + 250L < newStatsUpdate) {
            this.sendMessages();
            this.lastStatsUpdate = newStatsUpdate;
        }
    }

    public synchronized void updateStatOnJob(int jobStat, String parentNodeName) {
        StatBean bean = new StatBean(jobStat, parentNodeName);
        String key = String.valueOf(jobStat);
        if (this.keysList.contains(key)) {
            this.keysList.remove(key);
        }
        this.keysList.add(key);
        this.processStats.put(key, bean);
        this.sendMessages();
    }

    public void setAllPID(String rootPid, String fatherPid, String pid, String jobName) {
        this.rootPid = rootPid;
        this.fatherPid = fatherPid;
        this.pid = pid;
        this.jobName = jobName;
    }

    private class StatBean {
        private String itemId;
        private String connectionId;
        private int nbLine;
        private int state;
        private long startTime = 0L;
        private long endTime = 0L;
        private String exec = null;
        private boolean clearAfterSend;
        private int jobStat = JOBDEFAULT;

        public StatBean(int jobStat, String itemId) {
            this.jobStat = jobStat;
            this.itemId = itemId;
            if (jobStat == JOBSTART) {
                this.startTime = System.currentTimeMillis();
            } else if (jobStat == JOBEND) {
                this.endTime = System.currentTimeMillis();
            }
        }

        public StatBean(String connectionId) {
            this.connectionId = connectionId;
            this.startTime = System.currentTimeMillis();
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        public void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public int getNbLine() {
            return this.nbLine;
        }

        public void setNbLine(int nbLine) {
            this.nbLine = nbLine;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public String getExec() {
            return this.exec;
        }

        public void setExec(String exec) {
            this.exec = exec;
        }

        public int getJobStat() {
            return this.jobStat;
        }

        public void setJobStat(int jobStat) {
            this.jobStat = jobStat;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setClearAfterSend(boolean clearAfterSend) {
            this.clearAfterSend = clearAfterSend;
        }

        public boolean isClearAfterSend() {
            return this.clearAfterSend;
        }
    }
}

