/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.Arrays;

public class NoHeaderObjectInputStream
extends ObjectInputStream {
    private Class<?>[] expectedTypes;
    private boolean valid = false;

    public NoHeaderObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    public NoHeaderObjectInputStream(InputStream in, Class<?> ... expectedTypes) throws IOException {
        this(in);
        if (expectedTypes != null) {
            this.expectedTypes = new Class[expectedTypes.length];
            System.arraycopy(expectedTypes, 0, this.expectedTypes, 0, expectedTypes.length);
        }
    }

    protected NoHeaderObjectInputStream() throws IOException, SecurityException {
    }

    @Override
    protected void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.expectedTypes != null && !this.valid) {
            if (Arrays.stream(this.expectedTypes).anyMatch(c -> c.getName().equals(desc.getName()))) {
                this.valid = true;
            } else {
                throw new InvalidClassException("Unauthorized deserialization attempt : " + desc.getName());
            }
        }
        return super.resolveClass(desc);
    }
}

