/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LogCatcherUtils {
    List<LogCatcherMessage> messages = Collections.synchronizedList(new ArrayList());

    public void addMessage(String type, String origin, int priority, String message, int code) {
        LogCatcherMessage lcm = new LogCatcherMessage(type, origin, priority, message, code);
        this.messages.add(lcm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogCatcherMessage> getMessages() {
        ArrayList<LogCatcherMessage> messagesToSend = new ArrayList<LogCatcherMessage>();
        List<LogCatcherMessage> list = this.messages;
        synchronized (list) {
            int index = 0;
            while (index < this.messages.size()) {
                LogCatcherMessage lcm = this.messages.get(index);
                if (Thread.currentThread().getId() == lcm.getThreadId()) {
                    messagesToSend.add(lcm);
                    this.messages.remove(index);
                }
                ++index;
            }
        }
        return messagesToSend;
    }

    public class LogCatcherMessage {
        private String type;
        private String origin;
        private int priority;
        private String message;
        private int code;
        private long threadId;

        public LogCatcherMessage(String type, String origin, int priority, String message, int code) {
            this.type = type;
            this.origin = origin;
            this.priority = priority;
            this.message = message;
            this.code = code;
            this.threadId = Thread.currentThread().getId();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public long getThreadId() {
            return this.threadId;
        }
    }
}

