/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JobStructureCatcherUtils {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    List<JobStructureCatcherMessage> messages = Collections.synchronizedList(new ArrayList());
    public String job_name = "";
    public String job_id = "";
    public String job_version = "";

    public JobStructureCatcherUtils(String jobName, String jobId, String jobVersion) {
        this.job_name = jobName;
        this.job_id = jobId;
        this.job_version = jobVersion;
    }

    private void addMessage(String component_id, String component_name, Map<String, String> component_parameters, List<Map<String, String>> component_schema, String input_connectors, String output_connectors, Map<String, String> connector_name_2_connector_schema, boolean current_connector_as_input, String current_connector_type, String current_connector, String currrent_row_content, long row_count, long total_row_number, long start_time, long end_time, String status) {
        JobStructureCatcherMessage scm = new JobStructureCatcherMessage(component_id, component_name, component_parameters, component_schema, input_connectors, output_connectors, connector_name_2_connector_schema, this.job_name, this.job_id, this.job_version, current_connector_as_input, current_connector_type, current_connector, currrent_row_content, row_count, total_row_number, start_time, end_time, status);
        this.messages.add(scm);
    }

    public void addConnectionMessage(String component_id, String component_name, boolean current_connector_as_input, String current_connector_type, String current_connector, long total_row_number, long start_time, long end_time) {
        this.addMessage(component_id, component_name, null, null, null, null, null, current_connector_as_input, current_connector_type, current_connector, null, 0L, total_row_number, start_time, end_time, null);
    }

    public void addCM(String component_id, String component_name) {
        this.addMessage(component_id, component_name, null, null, null, null, null, false, null, null, null, 0L, 0L, 0L, 0L, null);
    }

    public void addJobStartMessage() {
        this.addMessage(null, null, null, null, null, null, null, false, null, null, null, 0L, 0L, 0L, 0L, null);
    }

    public void addJobEndMessage(long start_time, long end_time, String status) {
        this.addMessage(null, null, null, null, null, null, null, false, null, null, null, 0L, 0L, start_time, end_time, status == "" ? "end" : status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobStructureCatcherMessage> getMessages() {
        ArrayList<JobStructureCatcherMessage> messagesToSend = new ArrayList<JobStructureCatcherMessage>();
        List<JobStructureCatcherMessage> list = this.messages;
        synchronized (list) {
            for (JobStructureCatcherMessage scm : this.messages) {
                messagesToSend.add(scm);
            }
            this.messages.clear();
        }
        return messagesToSend;
    }

    public static long getPid() {
        RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
        String[] mxNameTable = mx.getName().split("@");
        if (mxNameTable.length == 2) {
            return Long.parseLong(mxNameTable[0]);
        }
        return Thread.currentThread().getId();
    }

    public class JobStructureCatcherMessage {
        public String component_id;
        public String component_name;
        public Map<String, String> component_parameters;
        public List<Map<String, String>> component_schema;
        public String input_connectors;
        public String output_connectors;
        public Map<String, String> connector_name_2_connector_schema;
        public String job_name;
        public String job_id;
        public String job_version;
        public Long systemPid;
        public boolean current_connector_as_input;
        public String current_connector_type;
        public String current_connector;
        public String currrent_row_content;
        public long row_count;
        public long total_row_number;
        public long start_time;
        public long end_time;
        public String moment;
        public String status;

        public JobStructureCatcherMessage(String component_id, String component_name, Map<String, String> component_parameters, List<Map<String, String>> component_schema, String input_connectors, String output_connectors, Map<String, String> connector_name_2_connector_schema, String job_name, String job_id, String job_version, boolean current_connector_as_input, String current_connector_type, String current_connector, String currrent_row_content, long row_count, long total_row_number, long start_time, long end_time, String status) {
            this.component_id = component_id;
            this.component_name = component_name;
            this.component_parameters = component_parameters;
            this.component_schema = component_schema;
            this.input_connectors = input_connectors;
            this.output_connectors = output_connectors;
            this.connector_name_2_connector_schema = connector_name_2_connector_schema;
            this.job_name = job_name;
            this.job_version = job_version;
            this.job_id = job_id;
            this.systemPid = JobStructureCatcherUtils.getPid();
            this.current_connector_as_input = current_connector_as_input;
            this.current_connector_type = current_connector_type;
            this.current_connector = current_connector;
            this.currrent_row_content = currrent_row_content;
            this.row_count = row_count;
            this.total_row_number = total_row_number;
            this.start_time = start_time;
            this.end_time = end_time;
            this.moment = sdf.format(new Date());
            this.status = status;
        }
    }
}

