/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentLookupCache {
    private LookupCache cache;

    public DocumentLookupCache(String matchingMode) {
        if ("UNIQUE_MATCH".equals(matchingMode)) {
            this.cache = new UniqueLookupCache();
        } else if ("FIRST_MATCH".equals(matchingMode)) {
            this.cache = new FirstLookupCache();
        } else if ("ALL_MATCHES".equals(matchingMode) || "ALL_ROWS".equals(matchingMode)) {
            this.cache = new AllMatchLookupCache();
        }
    }

    public void put(List<Object> key, Map<String, Object> value) {
        this.cache.put(key, value);
    }

    public void lookup(List<Object> key) {
        this.cache.lookup(key);
    }

    public boolean hasNext() {
        return this.cache.hasNext();
    }

    public Map<String, Object> next() {
        return this.cache.next();
    }

    class AllMatchLookupCache
    extends LookupCache {
        AllMatchLookupCache() {
        }

        @Override
        void put(List<Object> key, Map<String, Object> value) {
        }

        @Override
        void lookup(List<Object> key) {
        }

        @Override
        boolean hasNext() {
            return false;
        }

        @Override
        Map<String, Object> next() {
            return null;
        }
    }

    class FirstLookupCache
    extends LookupCache {
        private Map<List<Object>, Map<String, Object>> uniqueMap;

        FirstLookupCache() {
            this.uniqueMap = new HashMap<List<Object>, Map<String, Object>>();
        }

        @Override
        void put(List<Object> key, Map<String, Object> value) {
            this.uniqueMap.put(key, value);
        }

        @Override
        void lookup(List<Object> key) {
            this.currentValue = this.uniqueMap.get(key);
            this.hasNext = this.currentValue != null;
        }

        @Override
        boolean hasNext() {
            return this.hasNext;
        }

        @Override
        Map<String, Object> next() {
            return this.currentValue;
        }
    }

    abstract class LookupCache {
        protected boolean hasNext = false;
        protected Map<String, Object> currentValue;

        LookupCache() {
        }

        abstract void put(List<Object> var1, Map<String, Object> var2);

        abstract void lookup(List<Object> var1);

        abstract boolean hasNext();

        abstract Map<String, Object> next();
    }

    class UniqueLookupCache
    extends LookupCache {
        private Map<List<Object>, Map<String, Object>> uniqueMap = new HashMap<List<Object>, Map<String, Object>>();

        UniqueLookupCache() {
        }

        @Override
        void put(List<Object> key, Map<String, Object> value) {
            this.uniqueMap.put(key, value);
        }

        @Override
        void lookup(List<Object> key) {
            this.currentValue = this.uniqueMap.get(key);
            this.hasNext = this.currentValue != null;
        }

        @Override
        boolean hasNext() {
            return this.hasNext;
        }

        @Override
        Map<String, Object> next() {
            return this.currentValue;
        }
    }
}

