/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.talend.daikon.crypto.KeySource;

public class ComponentKeySource
implements KeySource {
    private static final Logger LOGGER = Logger.getLogger(ComponentKeySource.class.getName());
    private static final String ENCRYPTION_KEY_FILE_SYS_PROP = "encryption.keys.file";
    public static final String KEY_SYSTEM_PREFIX = "system.encryption.key.v";
    private static final String DEFAULT_KEY_FILE_NAME = "component.keys";
    private String keyName;
    private final boolean isEncrypt;
    private final Properties availableKeys;

    private ComponentKeySource(Properties allKeys, String keyName, boolean isEncrypt) {
        this.availableKeys = allKeys;
        this.keyName = keyName;
        this.isEncrypt = isEncrypt;
        if (this.isEncrypt) {
            this.keyName = this.availableKeys.stringPropertyNames().stream().max(Comparator.comparing(e -> ComponentKeySource.getVersion(e))).get();
        }
    }

    public static ComponentKeySource key(Properties allKeys, String keyName, boolean isEncrypt) {
        return new ComponentKeySource(allKeys, keyName, isEncrypt);
    }

    public byte[] getKey() throws Exception {
        String keyToLoad = this.getKeyName();
        String key = this.availableKeys.getProperty(keyToLoad);
        if (key == null) {
            LOGGER.log(Level.WARNING, "Can not load " + keyToLoad);
            throw new IllegalArgumentException("Invalid encryption key: " + keyToLoad);
        }
        LOGGER.log(Level.FINER, "Loaded " + keyToLoad);
        return Base64.getDecoder().decode(key.getBytes(StandardCharsets.UTF_8));
    }

    private static int getVersion(String keyName) {
        int idx = keyName.lastIndexOf(46);
        try {
            return Integer.parseInt(keyName.substring(idx + 2));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Parse version of encryption key error, key: " + keyName);
            return 0;
        }
    }

    public String getKeyName() {
        return this.keyName;
    }

    public static Properties loadAllKeys() {
        File keyFile;
        Properties keyProperties = new Properties();
        try (InputStream fi = ComponentKeySource.class.getResourceAsStream(DEFAULT_KEY_FILE_NAME);){
            keyProperties.load(fi);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        String keyPath = System.getProperty(ENCRYPTION_KEY_FILE_SYS_PROP);
        if (keyPath != null && (keyFile = new File(keyPath)).exists()) {
            Properties tempProperties = new Properties();
            try (FileInputStream fi = new FileInputStream(keyFile);){
                tempProperties.load(fi);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            tempProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = String.valueOf(k);
                if (key.startsWith(KEY_SYSTEM_PREFIX)) {
                    keyProperties.put(key, v);
                }
            }));
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = String.valueOf(k);
            if (key.startsWith(KEY_SYSTEM_PREFIX)) {
                keyProperties.put(key, v);
            }
        }));
        if (LOGGER.isLoggable(Level.FINER)) {
            keyProperties.stringPropertyNames().forEach(k -> LOGGER.log(Level.FINER, (String)k));
        }
        return keyProperties;
    }
}

