/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.component.runtime;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.component.runtime.Writer;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.exception.error.ComponentsErrorCode;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.java8.Supplier;

public class WriterDataSupplier<R, I> {
    private WriteOperation<R> writeOperation;
    private Supplier<I> supplier;
    private RuntimeContainer container;

    public WriterDataSupplier(WriteOperation<R> writeOperation, Supplier<I> supplier, RuntimeContainer container) {
        this.writeOperation = writeOperation;
        this.supplier = supplier;
        this.container = container;
    }

    public void writeData() {
        this.writeOperation.initialize(this.container);
        Writer<R> writer = this.writeOperation.createWriter(this.container);
        try {
            writer.open(RandomStringUtils.random((int)12));
            try {
                Object ir = this.supplier.get();
                if (ir != null) {
                    do {
                        writer.write(ir);
                    } while ((ir = this.supplier.get()) != null);
                }
            }
            finally {
                R result = writer.close();
                this.writeOperation.finalize(Collections.singleton(result), this.container);
            }
        }
        catch (IOException e) {
            throw TalendRuntimeException.build((ErrorCode)ComponentsErrorCode.IO_EXCEPTION, (Throwable)e).create();
        }
    }
}

