/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.component.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.talend.components.api.component.runtime.DependenciesReader;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.api.exception.error.ComponentsApiErrorCode;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.runtime.RuntimeInfo;

public class SimpleRuntimeInfo
implements RuntimeInfo {
    private String runtimeClassName;
    private ClassLoader classloader;
    private String depTxtPath;

    public SimpleRuntimeInfo(ClassLoader classloader, String depTxtPath, String runtimeClassName) {
        this.classloader = classloader;
        this.depTxtPath = depTxtPath;
        this.runtimeClassName = runtimeClassName;
    }

    public List<URL> getMavenUrlDependencies() {
        DependenciesReader dependenciesReader = new DependenciesReader(this.depTxtPath);
        try {
            Set<String> dependencies = dependenciesReader.getDependencies(this.classloader);
            ArrayList<URL> result = new ArrayList<URL>(dependencies.size());
            for (String urlString : dependencies) {
                result.add(new URL(urlString));
            }
            return result;
        }
        catch (IOException e) {
            throw new ComponentException(ComponentsApiErrorCode.COMPUTE_DEPENDENCIES_FAILED, e, ExceptionContext.withBuilder().put("path", (Object)dependenciesReader.getDependencyFilePath()).build());
        }
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!SimpleRuntimeInfo.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        SimpleRuntimeInfo other = (SimpleRuntimeInfo)obj;
        return this.runtimeClassName.equals(other.runtimeClassName) && this.depTxtPath.equals(other.depTxtPath);
    }

    public int hashCode() {
        return (this.runtimeClassName + this.depTxtPath).hashCode();
    }

    public String toString() {
        return "SimpleRuntimeInfo: {runtimeClassName:" + this.runtimeClassName + ", depTxtPath: " + this.depTxtPath + "}";
    }

    static {
        if (System.getProperty("sun.boot.class.path") == null) {
            System.setProperty("sun.boot.class.path", System.getProperty("java.class.path"));
        }
    }
}

