/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.component.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.talend.daikon.exception.TalendRuntimeException;

public class Result
implements Serializable {
    private static final long serialVersionUID = 8670579213592463768L;
    protected String uId;
    public int totalCount;
    public int successCount;
    public int rejectCount;

    public String getuId() {
        return this.uId;
    }

    public Result() {
    }

    public Result(String uId) {
        this.uId = uId;
    }

    public Result(String uId, int totalCount) {
        this(uId);
        this.totalCount = totalCount;
    }

    public Result(String uId, int totalCount, int successCount, int rejectCount) {
        this(uId, totalCount);
        this.successCount = successCount;
        this.rejectCount = rejectCount;
    }

    public static <T extends Result> Map<String, Object> accumulateAndReturnMap(Iterable<T> writerResults) {
        Result returnResult = null;
        for (Result result : writerResults) {
            if (returnResult == null) {
                try {
                    returnResult = (Result)result.getClass().newInstance();
                }
                catch (InstantiationException e) {
                    TalendRuntimeException.unexpectedException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    TalendRuntimeException.unexpectedException((Throwable)e);
                }
            }
            returnResult.add(result);
        }
        return returnResult.toMap();
    }

    public void add(Result result) {
        this.totalCount += result.getTotalCount();
        this.successCount += result.getSuccessCount();
        this.rejectCount += result.getRejectCount();
    }

    public static Map<String, Object> createResultMap(int totalCount, int successCount, int rejectCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("totalRecordCount", totalCount);
        map.put("successRecordCount", successCount);
        map.put("rejectRecordCount", rejectCount);
        return map;
    }

    public Map<String, Object> toMap() {
        return Result.createResultMap(this.totalCount, this.successCount, this.rejectCount);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getRejectCount() {
        return this.rejectCount;
    }

    public String toString() {
        return "total: " + this.totalCount + " success: " + this.successCount + " reject: " + this.rejectCount;
    }
}

