/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.component.runtime;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.talend.components.api.component.runtime.Reader;
import org.talend.components.api.exception.error.ComponentsErrorCode;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.java8.Consumer;

public class ReaderDataProvider<T> {
    private Reader<T> reader;
    private int limit;
    private Consumer<T> consumer;

    public ReaderDataProvider(Reader<T> reader, int limit, Consumer<T> consumer) {
        this.reader = reader;
        this.limit = limit;
        this.consumer = consumer;
    }

    public void retrieveData() {
        try {
            try {
                boolean hasCurrent = this.reader.start();
                int count = 0;
                while (hasCurrent && count++ < this.limit) {
                    this.consumer.accept(this.reader.getCurrent());
                    hasCurrent = this.reader.advance();
                }
                return;
            }
            finally {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw TalendRuntimeException.build((ErrorCode)ComponentsErrorCode.IO_EXCEPTION, (Throwable)e).create();
        }
        catch (NoSuchElementException e) {
            throw TalendRuntimeException.createUnexpectedException((Throwable)e);
        }
    }
}

