/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.component.runtime;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.Objects;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MavenResolvers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.runtime.DependenciesReader;
import org.talend.daikon.runtime.RuntimeInfo;
import org.talend.daikon.sandbox.SandboxControl;

public class JarRuntimeInfo
implements RuntimeInfo,
SandboxControl {
    private static final Logger LOG = LoggerFactory.getLogger(JarRuntimeInfo.class);
    private final String runtimeClassName;
    private final URL jarUrl;
    private final String depTxtPath;
    private final boolean reusable;

    public JarRuntimeInfo(URL jarUrl, String depTxtPath, String runtimeClassName) {
        this(jarUrl, depTxtPath, runtimeClassName, true);
    }

    public JarRuntimeInfo(URL jarUrl, String depTxtPath, String runtimeClassName, boolean reusable) {
        this.jarUrl = jarUrl;
        this.depTxtPath = depTxtPath;
        this.runtimeClassName = runtimeClassName;
        this.reusable = reusable;
    }

    public JarRuntimeInfo(String jarUrlString, String depTxtPath, String runtimeClassName) {
        this(JarRuntimeInfo.createJarUrl(jarUrlString), depTxtPath, runtimeClassName, true);
    }

    public JarRuntimeInfo(String jarUrlString, String depTxtPath, String runtimeClassName, boolean reusable) {
        this(JarRuntimeInfo.createJarUrl(jarUrlString), depTxtPath, runtimeClassName, reusable);
    }

    private static URL createJarUrl(String jarUrlString) {
        try {
            return new URL(jarUrlString);
        }
        catch (MalformedURLException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }

    public JarRuntimeInfo cloneWithNewJarUrlString(String newJarUrlString) {
        return new JarRuntimeInfo(newJarUrlString, this.getDepTxtPath(), this.getRuntimeClassName());
    }

    public URL getJarUrl() {
        return this.jarUrl;
    }

    public String getDepTxtPath() {
        return this.depTxtPath;
    }

    public List<URL> getMavenUrlDependencies() {
        return DependenciesReader.extractDepenencies(this.jarUrl, this.depTxtPath);
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public boolean isClassLoaderReusable() {
        return this.reusable;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!JarRuntimeInfo.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        JarRuntimeInfo other = (JarRuntimeInfo)obj;
        return this.runtimeClassName.equals(other.runtimeClassName) && this.getMavenUrlDependencies().equals(other.getMavenUrlDependencies());
    }

    public int hashCode() {
        return Objects.hash(this.runtimeClassName, this.getMavenUrlDependencies());
    }

    public String toString() {
        return "JarRunTimeInfo: {runtimeClassName:" + this.runtimeClassName + ", jarUrl: " + this.jarUrl + ", depTxtPath: " + this.depTxtPath + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            new URL("mvn:foo/bar");
        }
        catch (MalformedURLException e) {
            String mvnLocalRepo = System.getProperty("maven.repo.local");
            if (mvnLocalRepo != null && !mvnLocalRepo.isEmpty()) {
                System.setProperty("org.ops4j.pax.url.mvn.localRepository", mvnLocalRepo);
            }
            try {
                Field factoryField = URL.class.getDeclaredField("factory");
                factoryField.setAccessible(true);
                Field lockField = URL.class.getDeclaredField("streamHandlerLock");
                lockField.setAccessible(true);
                Object object = lockField.get(null);
                synchronized (object) {
                    URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                    if (factory == null) {
                        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                            @Override
                            public URLStreamHandler createURLStreamHandler(String protocol) {
                                if (!"mvn".equals(protocol)) {
                                    return null;
                                }
                                return new URLStreamHandler(){

                                    @Override
                                    public URLConnection openConnection(URL url) throws IOException {
                                        MavenResolver resolver = MavenResolvers.createMavenResolver(null, (String)"org.ops4j.pax.url.mvn");
                                        Connection conn = new Connection(new URL(url.toExternalForm().replace("#runtime", "")), resolver);
                                        conn.setUseCaches(false);
                                        return conn;
                                    }

                                    @Override
                                    protected void parseURL(URL u, String spec, int start, int limit) {
                                        if (!"mvn:".equals(u.toString())) {
                                            LOG.debug("ignoring specs for parseUrl with url[" + u + "] and spec[" + spec + "]");
                                            super.parseURL(u, "", 0, 0);
                                        } else {
                                            super.parseURL(u, spec, start, limit);
                                        }
                                    }
                                };
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
                LOG.warn(exception.getMessage());
            }
        }
        if (System.getProperty("sun.boot.class.path") == null) {
            System.setProperty("sun.boot.class.path", System.getProperty("java.class.path"));
        }
    }

    private static class Connection
    extends URLConnection {
        private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
        private final MavenResolver resolver;

        private Connection(URL url, MavenResolver resolver) {
            super(url);
            this.resolver = resolver;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            LOG.debug("Resolving [" + this.url.toExternalForm() + "]");
            return new FileInputStream(this.resolver.resolve(this.url.toExternalForm()));
        }
    }
}

