/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.support_vector_machine;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.support_vector_machine.Coefficient;
import org.dmg.pmml.support_vector_machine.Coefficients;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.PMMLAttributes;
import org.dmg.pmml.support_vector_machine.SupportVector;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.SupportVectors;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.SparseArrayUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.support_vector_machine.DistanceDistribution;
import org.jpmml.evaluator.support_vector_machine.KernelUtil;
import org.jpmml.evaluator.support_vector_machine.VoteMap;
import org.jpmml.evaluator.support_vector_machine.VoteProbabilityDistribution;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.InvalidElementListException;
import org.jpmml.model.MisplacedAttributeException;
import org.jpmml.model.MisplacedElementException;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.ReflectionUtil;

public class SupportVectorMachineModelEvaluator
extends ModelEvaluator<SupportVectorMachineModel> {
    private Map<String, Object> vectorMap = Collections.emptyMap();

    private SupportVectorMachineModelEvaluator() {
    }

    public SupportVectorMachineModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, SupportVectorMachineModel.class));
    }

    public SupportVectorMachineModelEvaluator(PMML pmml, SupportVectorMachineModel supportVectorMachineModel) {
        super(pmml, supportVectorMachineModel);
        boolean maxWins = supportVectorMachineModel.isMaxWins();
        if (maxWins) {
            throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, PMMLAttributes.SUPPORTVECTORMACHINEMODEL_MAXWINS, maxWins);
        }
        SupportVectorMachineModel.Representation representation = supportVectorMachineModel.getRepresentation();
        switch (representation) {
            case SUPPORT_VECTORS: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)representation);
            }
        }
        List supportVectorMachines = supportVectorMachineModel.requireSupportVectorMachines();
        this.vectorMap = ImmutableMap.copyOf(SupportVectorMachineModelEvaluator.parseVectorDictionary(supportVectorMachineModel));
    }

    @Override
    public String getSummary() {
        return "Support vector machine";
    }

    @Override
    protected <V extends Number> Map<String, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        List supportVectorMachines = supportVectorMachineModel.requireSupportVectorMachines();
        if (supportVectorMachines.size() != 1) {
            throw new InvalidElementListException(supportVectorMachines);
        }
        SupportVectorMachine supportVectorMachine = (SupportVectorMachine)supportVectorMachines.get(0);
        Object input = this.createInput(context);
        Value<V> result = this.evaluateSupportVectorMachine(valueFactory, supportVectorMachine, input);
        return TargetUtil.evaluateRegression(this.getTargetField(), result);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <V extends Number> Map<String, ? extends Classification<?, V>> evaluateClassification(final ValueFactory<V> valueFactory, EvaluationContext context) {
        VoteMap values;
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        List supportVectorMachines = supportVectorMachineModel.requireSupportVectorMachines();
        Object alternateBinaryTargetCategory = supportVectorMachineModel.getAlternateBinaryTargetCategory();
        SupportVectorMachineModel.ClassificationMethod classificationMethod = this.getClassificationMethod();
        switch (classificationMethod) {
            case ONE_AGAINST_ALL: {
                values = new ValueMap(2 * supportVectorMachines.size());
                break;
            }
            case ONE_AGAINST_ONE: {
                values = new VoteMap<Object, V>(2 * supportVectorMachines.size()){

                    @Override
                    public ValueFactory<V> getValueFactory() {
                        return valueFactory;
                    }
                };
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)classificationMethod);
            }
        }
        Object input = this.createInput(context);
        for (SupportVectorMachine supportVectorMachine : supportVectorMachines) {
            Object targetCategory = supportVectorMachine.requireTargetCategory();
            Object alternateTargetCategory = supportVectorMachine.getAlternateTargetCategory();
            Value<V> value = this.evaluateSupportVectorMachine(valueFactory, supportVectorMachine, input);
            switch (classificationMethod) {
                case ONE_AGAINST_ALL: {
                    if (alternateTargetCategory != null) {
                        throw new MisplacedAttributeException((PMMLObject)supportVectorMachine, PMMLAttributes.SUPPORTVECTORMACHINE_ALTERNATETARGETCATEGORY, alternateTargetCategory);
                    }
                    values.put(targetCategory, value);
                    break;
                }
                case ONE_AGAINST_ONE: {
                    Object label;
                    if (alternateBinaryTargetCategory != null) {
                        if (alternateTargetCategory != null) {
                            throw new MisplacedAttributeException((PMMLObject)supportVectorMachine, PMMLAttributes.SUPPORTVECTORMACHINE_ALTERNATETARGETCATEGORY, alternateTargetCategory);
                        }
                        value.round();
                        if (value.isZero()) {
                            label = alternateBinaryTargetCategory;
                        } else {
                            if (!value.isOne()) throw new EvaluationException("Expected " + EvaluationException.formatValue(Numbers.DOUBLE_ZERO) + " or " + EvaluationException.formatValue(Numbers.DOUBLE_ONE) + ", got " + EvaluationException.formatValue(value.getValue()));
                            label = targetCategory;
                        }
                    } else {
                        if (alternateTargetCategory == null) {
                            throw new MissingAttributeException((PMMLObject)supportVectorMachine, PMMLAttributes.SUPPORTVECTORMACHINE_ALTERNATETARGETCATEGORY);
                        }
                        Number threshold = supportVectorMachine.getThreshold();
                        if (threshold == null) {
                            threshold = supportVectorMachineModel.getThreshold();
                        }
                        label = value.compareTo(threshold) < 0 ? targetCategory : alternateTargetCategory;
                    }
                    VoteMap votes = values;
                    votes.increment(label);
                    break;
                }
            }
        }
        switch (classificationMethod) {
            case ONE_AGAINST_ALL: {
                void var9_12;
                DistanceDistribution distanceDistribution = new DistanceDistribution(values);
                return TargetUtil.evaluateClassification(this.getTargetField(), var9_12);
            }
            case ONE_AGAINST_ONE: {
                void var9_12;
                VoteProbabilityDistribution voteProbabilityDistribution = new VoteProbabilityDistribution(values);
                return TargetUtil.evaluateClassification(this.getTargetField(), var9_12);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)classificationMethod);
            }
        }
    }

    private <V extends Number> Value<V> evaluateSupportVectorMachine(ValueFactory<V> valueFactory, SupportVectorMachine supportVectorMachine, Object input) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        Value<V> result = valueFactory.newValue();
        Kernel kernel = supportVectorMachineModel.requireKernel();
        Coefficients coefficients = supportVectorMachine.getCoefficients();
        Iterator coefficientIt = coefficients.iterator();
        SupportVectors supportVectors = supportVectorMachine.getSupportVectors();
        Iterator supportVectorIt = supportVectors.iterator();
        Map<String, Object> vectorMap = this.getVectorMap();
        while (coefficientIt.hasNext() && supportVectorIt.hasNext()) {
            Coefficient coefficient = (Coefficient)coefficientIt.next();
            SupportVector supportVector = (SupportVector)supportVectorIt.next();
            String vectorId = supportVector.requireVectorId();
            Object vector = vectorMap.get(vectorId);
            if (vector == null) {
                throw new InvalidAttributeException((PMMLObject)supportVector, PMMLAttributes.SUPPORTVECTOR_VECTORID, (Object)vectorId);
            }
            Value<V> value = KernelUtil.evaluate(kernel, valueFactory, input, vector);
            result.add(coefficient.getValue(), (Number)value.getValue());
        }
        if (coefficientIt.hasNext() || supportVectorIt.hasNext()) {
            throw new InvalidElementException((PMMLObject)supportVectorMachine);
        }
        result.add(coefficients.getAbsoluteValue());
        return result;
    }

    private SupportVectorMachineModel.ClassificationMethod getClassificationMethod() {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        SupportVectorMachineModel.ClassificationMethod classificationMethod = (SupportVectorMachineModel.ClassificationMethod)ReflectionUtil.getFieldValue((Field)PMMLAttributes.SUPPORTVECTORMACHINEMODEL_CLASSIFICATIONMETHOD, (Object)supportVectorMachineModel);
        if (classificationMethod != null) {
            return classificationMethod;
        }
        List supportVectorMachines = supportVectorMachineModel.requireSupportVectorMachines();
        Object alternateBinaryTargetCategory = supportVectorMachineModel.getAlternateBinaryTargetCategory();
        if (alternateBinaryTargetCategory != null) {
            if (supportVectorMachines.size() == 1) {
                SupportVectorMachine supportVectorMachine = (SupportVectorMachine)supportVectorMachines.get(0);
                Object targetCategory = supportVectorMachine.getTargetCategory();
                if (targetCategory != null) {
                    return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE;
                }
                throw new InvalidElementException((PMMLObject)supportVectorMachine);
            }
            throw new InvalidElementException((PMMLObject)supportVectorMachineModel);
        }
        Iterator iterator = supportVectorMachines.iterator();
        if (iterator.hasNext()) {
            SupportVectorMachine supportVectorMachine = (SupportVectorMachine)iterator.next();
            Object targetCategory = supportVectorMachine.getTargetCategory();
            Object alternateTargetCategory = supportVectorMachine.getAlternateTargetCategory();
            if (targetCategory != null) {
                if (alternateTargetCategory != null) {
                    return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE;
                }
                return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ALL;
            }
            throw new InvalidElementException((PMMLObject)supportVectorMachine);
        }
        throw new InvalidElementException((PMMLObject)supportVectorMachineModel);
    }

    private Object createInput(EvaluationContext context) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        VectorDictionary vectorDictionary = supportVectorMachineModel.requireVectorDictionary();
        VectorFields vectorFields = vectorDictionary.requireVectorFields();
        List content = vectorFields.getContent();
        ArrayList<Number> result = new ArrayList<Number>(content.size());
        int max = content.size();
        for (int i = 0; i < max; ++i) {
            FieldValue value;
            PMMLObject object = (PMMLObject)content.get(i);
            if (object instanceof FieldRef) {
                FieldRef fieldRef = (FieldRef)object;
                value = ExpressionUtil.evaluate((Expression)fieldRef, context);
                if (FieldValueUtil.isMissing(value)) {
                    throw new MissingFieldValueException(fieldRef);
                }
                result.add(value.asNumber());
                continue;
            }
            if (object instanceof CategoricalPredictor) {
                CategoricalPredictor categoricalPredictor = (CategoricalPredictor)object;
                value = context.evaluate(categoricalPredictor.requireField());
                if (FieldValueUtil.isMissing(value)) {
                    throw new MissingFieldValueException(categoricalPredictor);
                }
                Number coefficient = categoricalPredictor.getCoefficient();
                if (coefficient != null && coefficient.doubleValue() != 1.0) {
                    throw new InvalidAttributeException((PMMLObject)categoricalPredictor, org.dmg.pmml.regression.PMMLAttributes.CATEGORICALPREDICTOR_COEFFICIENT, (Object)coefficient);
                }
                boolean equals = value.equals((HasValue<?>)categoricalPredictor);
                result.add(equals ? Numbers.DOUBLE_ONE : Numbers.DOUBLE_ZERO);
                continue;
            }
            throw new MisplacedElementException(object);
        }
        return SupportVectorMachineModelEvaluator.toArray(supportVectorMachineModel, result);
    }

    private Map<String, Object> getVectorMap() {
        return this.vectorMap;
    }

    private static Map<String, Object> parseVectorDictionary(SupportVectorMachineModel supportVectorMachineModel) {
        VectorDictionary vectorDictionary = supportVectorMachineModel.requireVectorDictionary();
        VectorFields vectorFields = vectorDictionary.requireVectorFields();
        List content = vectorFields.getContent();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List vectorInstances = vectorDictionary.getVectorInstances();
        for (VectorInstance vectorInstance : vectorInstances) {
            List<Number> values;
            String id = vectorInstance.requireId();
            Array array = vectorInstance.getArray();
            RealSparseArray sparseArray = vectorInstance.getRealSparseArray();
            if (array != null && sparseArray == null) {
                values = ArrayUtil.asNumberList(array);
            } else if (array == null && sparseArray != null) {
                values = SparseArrayUtil.asNumberList(sparseArray);
            } else {
                throw new InvalidElementException((PMMLObject)vectorInstance);
            }
            if (content.size() != values.size()) {
                throw new InvalidElementException((PMMLObject)vectorInstance);
            }
            Object vector = SupportVectorMachineModelEvaluator.toArray(supportVectorMachineModel, values);
            result.put(id, vector);
        }
        return result;
    }

    private static Object toArray(SupportVectorMachineModel supportVectorMachineModel, List<? extends Number> values) {
        MathContext mathContext = supportVectorMachineModel.getMathContext();
        switch (mathContext) {
            case FLOAT: {
                return Floats.toArray(values);
            }
            case DOUBLE: {
                return Doubles.toArray(values);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)mathContext);
    }
}

