/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TokenizedString {
    private int hashCode = 0;
    private String[] tokens = null;
    public static final TokenizedString EMPTY = new TokenizedString(new String[0]){

        @Override
        public int hashCode() {
            return 0;
        }
    };

    public TokenizedString(String ... tokens) {
        this.setTokens(tokens);
    }

    public TokenizedString(List<String> tokens) {
        this(tokens.toArray(new String[tokens.size()]));
    }

    public int size() {
        String[] tokens = this.getTokens();
        return tokens.length;
    }

    public String get(int i) {
        String[] tokens = this.getTokens();
        return tokens[i];
    }

    public TokenizedString slice(int fromIndex, int toIndex) {
        String[] tokens = this.getTokens();
        if (fromIndex == 0 && toIndex == tokens.length) {
            return this;
        }
        String[] newTokens = new String[toIndex - fromIndex];
        System.arraycopy(tokens, fromIndex, newTokens, 0, toIndex - fromIndex);
        return new TokenizedString(newTokens);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.getTokens());
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof TokenizedString) {
            TokenizedString that = (TokenizedString)object;
            return Arrays.equals(this.getTokens(), that.getTokens());
        }
        return false;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    private void setTokens(String[] tokens) {
        this.tokens = Objects.requireNonNull(tokens);
    }
}

