/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jpmml.translator.JClassInitializer;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.TranslationContext;

public class JDirectInitializer
extends JClassInitializer {
    public JDirectInitializer(TranslationContext context) {
        super(context);
    }

    @Override
    public void add(JStatement statement) {
        TranslationContext context = this.getContext();
        JDefinedClass owner = context.getOwner();
        JBlock init = owner.init();
        init.add(statement);
    }

    public JFieldVar initLambdas(String name, JType type, List<JMethod> methods) {
        TranslationContext context = this.getContext();
        JFieldVar constant = JDirectInitializer.createConstant(name, type, context);
        JMethod initMethod = JDirectInitializer.createMethod(name, context);
        List<JExpression> lambdas = methods.stream().map(method -> JExpr.direct((String)JDirectInitializer.formatLambda(method))).collect(Collectors.toList());
        JInvocation invocation = JDirectInitializer.populateConstant(constant, lambdas, context);
        initMethod.body().add((JStatement)invocation);
        this.add((JStatement)JExpr.invoke((JMethod)initMethod));
        return constant;
    }

    public JFieldVar initTargetCategories(String name, List<?> categories) {
        TranslationContext context = this.getContext();
        JFieldVar constant = JDirectInitializer.createConstant(name, (JType)context.ref(Object.class), context);
        List<JExpression> literals = categories.stream().map(category -> PMMLObjectUtil.createExpression(category, context)).collect(Collectors.toList());
        JInvocation invocation = JDirectInitializer.populateConstant(constant, literals, context);
        this.add((JStatement)invocation);
        return constant;
    }

    private static String formatLambda(JMethod method) {
        JDefinedClass outer;
        try {
            Field field = JMethod.class.getDeclaredField("outer");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            outer = (JDefinedClass)field.get(method);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        return outer.name() + "::" + method.name();
    }

    private static JInvocation populateConstant(JFieldVar constant, List<JExpression> exprs, TranslationContext context) {
        JInvocation invocation = context.staticInvoke(Collections.class, "addAll", constant);
        for (JExpression expr : exprs) {
            invocation = invocation.arg(expr);
        }
        return invocation;
    }
}

