/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.general_regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.PMMLElements;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Categories", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "categories"})
@Added(value=Version.PMML_4_1)
@JsonRootName(value="Categories")
@JsonPropertyOrder(value={"extensions", "categories"})
public class Categories
extends PMMLObject
implements Iterable<Category>,
HasExtensions<Categories> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="Category", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Category")
    private List<Category> categories;
    private static final long serialVersionUID = 67371269L;

    public Categories() {
    }

    @ValueConstructor
    public Categories(@Property(value="categories") List<Category> categories) {
        this.categories = categories;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Categories addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Category> iterator() {
        return this.requireCategories().iterator();
    }

    public boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    public List<Category> requireCategories() {
        if (this.categories == null || this.categories.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.CATEGORIES_CATEGORIES);
        }
        return this.categories;
    }

    public List<Category> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        return this.categories;
    }

    public Categories addCategories(Category ... categories) {
        this.getCategories().addAll(Arrays.asList(categories));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasCategories()) {
                status = PMMLObject.traverse(visitor, this.getCategories());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

