/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.model.ToStringHelper;

public class PowerFeature
extends Feature
implements HasDerivedName {
    private int power = 1;

    public PowerFeature(PMMLEncoder encoder, Field<?> field, int power) {
        this(encoder, field.requireName(), field.getDataType(), power);
    }

    public PowerFeature(PMMLEncoder encoder, Feature feature, int power) {
        this(encoder, feature.getName(), feature.getDataType(), power);
    }

    public PowerFeature(PMMLEncoder encoder, String name, DataType dataType, int power) {
        super(encoder, name, dataType);
        this.setPower(power);
    }

    @Override
    public String getDerivedName() {
        return this.getName() + "^" + this.getPower();
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        return this.toContinuousFeature(this.getDerivedName(), DataType.DOUBLE, () -> PMMLUtil.createApply("pow", new Expression[]{this.ref(), PMMLUtil.createConstant(this.getPower())}));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.getPower();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PowerFeature) {
            PowerFeature that = (PowerFeature)object;
            return super.equals(object) && this.getPower() == that.getPower();
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("power", (Object)this.getPower());
    }

    public int getPower() {
        return this.power;
    }

    private void setPower(int power) {
        this.power = power;
    }
}

