/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.ThresholdFeature;

public class ThresholdFeatureUtil {
    private ThresholdFeatureUtil() {
    }

    public static Predicate createPredicate(ThresholdFeature thresholdFeature, List<?> values, Object missingValue, PredicateManager predicateManager) {
        Predicate missingValuePredicate;
        boolean checkMissing = values.remove(missingValue);
        Predicate valuesPredicate = !values.isEmpty() ? predicateManager.createPredicate(thresholdFeature, values) : null;
        Predicate predicate = missingValuePredicate = checkMissing ? predicateManager.createSimplePredicate(thresholdFeature, SimplePredicate.Operator.IS_MISSING, null) : null;
        if (valuesPredicate != null) {
            if (missingValuePredicate != null) {
                return predicateManager.createCompoundPredicate(CompoundPredicate.BooleanOperator.SURROGATE, valuesPredicate, missingValuePredicate);
            }
            return valuesPredicate;
        }
        if (missingValuePredicate != null) {
            return missingValuePredicate;
        }
        return False.INSTANCE;
    }

    public static boolean isMissingValueSafe(Predicate predicate) {
        if (predicate instanceof SimplePredicate) {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            SimplePredicate.Operator operator = simplePredicate.requireOperator();
            switch (operator) {
                case IS_MISSING: {
                    return true;
                }
                case IS_NOT_MISSING: {
                    return false;
                }
            }
            return false;
        }
        if (predicate instanceof SimpleSetPredicate) {
            SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)predicate;
            return false;
        }
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            CompoundPredicate.BooleanOperator booleanOperator = compoundPredicate.requireBooleanOperator();
            switch (booleanOperator) {
                case SURROGATE: {
                    return true;
                }
            }
            return false;
        }
        if (predicate instanceof False) {
            return false;
        }
        throw new IllegalArgumentException();
    }
}

