/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.writer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.component.runtime.WriterWithFeedback;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.common.avro.JDBCAvroRegistry;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.JDBCRowSink;
import org.talend.components.jdbc.runtime.JdbcRuntimeUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public class JDBCRowWriter
implements WriterWithFeedback<Result, IndexedRecord, IndexedRecord> {
    private static final transient Logger LOG = LoggerFactory.getLogger(JDBCRowWriter.class);
    private WriteOperation<Result> writeOperation;
    private Connection conn;
    private JDBCRowSink sink;
    private AllSetting setting;
    private RuntimeSettingProvider properties;
    private RuntimeContainer runtime;
    private Result result;
    private final List<IndexedRecord> successfulWrites = new ArrayList<IndexedRecord>();
    private final List<IndexedRecord> rejectedWrites = new ArrayList<IndexedRecord>();
    private int successCount;
    private int rejectCount;
    private boolean useExistedConnection;
    private boolean dieOnError;
    private PreparedStatement prepared_statement;
    private Statement statement;
    private ResultSet resultSet;
    private boolean usePreparedStatement;
    private String sql;
    private boolean propagateQueryResultSet;
    private boolean useCommit;
    private int commitCount;
    private int commitEvery;
    private Schema outSchema;
    private Schema rejectSchema;
    private IndexedRecordConverter<Object, ? extends IndexedRecord> factory;

    public JDBCRowWriter(WriteOperation<Result> writeOperation, RuntimeContainer runtime) {
        this.writeOperation = writeOperation;
        this.runtime = runtime;
        this.sink = (JDBCRowSink)writeOperation.getSink();
        this.setting = this.sink.properties.getRuntimeSetting();
        this.properties = this.sink.properties;
        this.useExistedConnection = this.setting.getReferencedComponentId() != null;
        Integer commitEveryNumber = this.setting.getCommitEvery();
        boolean bl = this.useCommit = !this.useExistedConnection && commitEveryNumber != null && commitEveryNumber != 0;
        if (this.useCommit) {
            this.commitEvery = commitEveryNumber;
        }
        this.dieOnError = this.setting.getDieOnError();
        this.propagateQueryResultSet = this.setting.getPropagateQueryResultSet();
        this.result = new Result();
        this.outSchema = CommonUtils.getOutputSchema((ComponentProperties)((ComponentProperties)this.properties));
        this.rejectSchema = CommonUtils.getRejectSchema((ComponentProperties)((ComponentProperties)this.properties));
    }

    public void open(String uId) throws IOException {
        try {
            this.conn = this.sink.getConnection(this.runtime);
            this.usePreparedStatement = this.setting.getUsePreparedStatement();
            this.sql = this.setting.getSql();
            if (this.usePreparedStatement) {
                this.prepared_statement = this.conn.prepareStatement(this.sql);
            } else {
                this.statement = this.conn.createStatement();
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public void write(Object datum) throws IOException {
        ++this.result.totalCount;
        this.cleanWrites();
        IndexedRecord input = (IndexedRecord)this.getFactory(datum).convertToAvro(datum);
        this.setting = this.sink.properties.getRuntimeSetting();
        try {
            if (this.usePreparedStatement) {
                JdbcRuntimeUtils.setPreparedStatement(this.prepared_statement, this.setting.getIndexs(), this.setting.getTypes(), this.setting.getValues());
                if (this.propagateQueryResultSet) {
                    this.resultSet = this.prepared_statement.executeQuery();
                } else {
                    this.prepared_statement.execute();
                }
            } else if (this.propagateQueryResultSet) {
                this.resultSet = this.statement.executeQuery(this.setting.getSql());
            } else {
                this.statement.execute(this.setting.getSql());
            }
            this.handleSuccess(input);
        }
        catch (SQLException e) {
            if (this.dieOnError) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
            LOG.warn(e.getMessage());
            System.err.println(e.getMessage());
            this.handleReject(input, e);
        }
        try {
            this.executeCommit();
        }
        catch (SQLException e) {
            if (this.dieOnError) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
            LOG.warn(e.getMessage());
        }
    }

    public Result close() throws IOException {
        this.closeStatementQuietly(this.prepared_statement);
        this.prepared_statement = null;
        this.closeStatementQuietly(this.statement);
        this.statement = null;
        this.commitAndCloseAtLast();
        this.constructResult();
        return this.result;
    }

    private void commitAndCloseAtLast() {
        if (this.useExistedConnection) {
            return;
        }
        try {
            if (this.useCommit && this.commitCount > 0) {
                this.commitCount = 0;
                if (this.conn != null) {
                    this.conn.commit();
                }
            }
            if (this.conn != null) {
                if (this.useCommit) {
                    this.conn.commit();
                }
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public WriteOperation<Result> getWriteOperation() {
        return this.writeOperation;
    }

    private IndexedRecordConverter<Object, ? extends IndexedRecord> getFactory(Object datum) {
        if (null == this.factory) {
            this.factory = JDBCAvroRegistry.get().createIndexedRecordConverter(datum.getClass());
        }
        return this.factory;
    }

    public List<IndexedRecord> getSuccessfulWrites() {
        return Collections.unmodifiableList(this.successfulWrites);
    }

    public List<IndexedRecord> getRejectedWrites() {
        return Collections.unmodifiableList(this.rejectedWrites);
    }

    public void cleanWrites() {
        this.successfulWrites.clear();
        this.rejectedWrites.clear();
    }

    private void handleSuccess(IndexedRecord input) {
        ++this.successCount;
        if (this.outSchema == null || this.outSchema.getFields().size() == 0) {
            return;
        }
        GenericData.Record output = new GenericData.Record(this.outSchema);
        for (Schema.Field outField : output.getSchema().getFields()) {
            Object outValue = null;
            if (this.propagateQueryResultSet && outField.name().equals(this.setting.getUseColumn())) {
                output.put(outField.pos(), (Object)this.resultSet);
                continue;
            }
            Schema.Field inField = input.getSchema().getField(outField.name());
            if (inField != null) {
                outValue = input.get(inField.pos());
            }
            output.put(outField.pos(), outValue);
        }
        this.successfulWrites.add((IndexedRecord)output);
    }

    private void handleReject(IndexedRecord input, SQLException e) throws IOException {
        ++this.rejectCount;
        GenericData.Record reject = new GenericData.Record(this.rejectSchema);
        for (Schema.Field outField : reject.getSchema().getFields()) {
            Object outValue = null;
            Schema.Field inField = input.getSchema().getField(outField.name());
            if (inField != null) {
                outValue = input.get(inField.pos());
            } else if ("errorCode".equals(outField.name())) {
                outValue = e.getSQLState();
            } else if ("errorMessage".equals(outField.name())) {
                outValue = e.getMessage() + " - Line: " + this.result.totalCount;
            }
            reject.put(outField.pos(), outValue);
        }
        this.rejectedWrites.add((IndexedRecord)reject);
    }

    private void executeCommit() throws SQLException {
        if (this.useCommit) {
            if (this.commitCount < this.commitEvery) {
                ++this.commitCount;
            } else {
                this.commitCount = 0;
                this.conn.commit();
            }
        }
    }

    private void closeStatementQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void constructResult() {
        this.result.successCount = this.successCount;
        this.result.rejectCount = this.rejectCount;
    }
}

